import json
import argparse
import sys

import pydash

parser = argparse.ArgumentParser()

parser.add_argument('--path', help='File path')
parser.add_argument('--key', help='Key')
parser.add_argument('--value', help='Value')

args = parser.parse_args()


def main():

    if args.path is None:
        raise Exception('Path must be set')

    if args.key is None:
        raise Exception('Key must be set')

    with open(args.path, 'r+') as configFile:

        config = json.loads(configFile.read())

        if args.value is not None:

            config = pydash.objects.set_(config, args.key, args.value)

            configFile.seek(0)

            configFile.write(json.dumps(config))

            configFile.truncate()

        else:

            value = pydash.objects.get(config, args.key)

            if type(value) is list or type(value) is dict:

                print(json.dumps(value))

            else:

                print(value)

        configFile.close()


if __name__ == "__main__":
    main()
