/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.version.installer;

import com.gamedash.daemon.wrapper.Application;
import com.gamedash.daemon.wrapper.version.Version;
import com.gamedash.daemon.wrapper.version.Versions;
import com.gamedash.daemon.wrapper.version.daemon.loader.DaemonLoader;
import com.gamedash.daemon.wrapper.version.file.VersionFile;
import com.gamedash.daemon.wrapper.version.installer.InstallerException;
import com.gamedash.daemon.wrapper.version.installer.InvalidSHA1ChecksumException;
import com.gamedash.daemon.wrapper.version.installer.VersionAlreadyLatestException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Installer {
    private static final Logger logger = LoggerFactory.getLogger(Installer.class);
    private static boolean isInstalling = false;
    private static boolean isUninstalling = false;
    private static boolean isUpdating = false;
    private final Version version;

    public Installer(Version version) {
        this.version = version;
    }

    public void install() throws Exception {
        if (this.version.isInstalled()) {
            throw new InstallerException("Version is already installed");
        }
        if (Installer.isInProgress()) {
            throw new InstallerException("An installation is already in progress");
        }
        Installer.setIsInstalling(true);
        try {
            this.download();
        }
        catch (InvalidSHA1ChecksumException e) {
            for (VersionFile file : this.version.getFiles().getInstalled()) {
                file.uninstall();
            }
            throw e;
        }
        finally {
            Installer.setIsInstalling(false);
        }
        Versions.addInstalled(this.version);
    }

    public void uninstall() throws Exception {
        if (!this.version.isInstalled()) {
            throw new Exception("Version is not installed");
        }
        if (Installer.isInProgress()) {
            throw new InstallerException("An installation is already in progress");
        }
        Installer.setIsUninstalling(true);
        try {
            for (VersionFile installedFile : this.version.getFiles().getInstalled()) {
                installedFile.uninstall();
            }
            Versions.removeInstalled(this.version);
        }
        finally {
            Installer.setIsUninstalling(false);
        }
    }

    public static void update() throws Exception {
        Version latestVersion;
        Version currentVersion = Versions.getCurrent();
        if (currentVersion.isEqualTo(latestVersion = Versions.getLatest())) {
            throw new VersionAlreadyLatestException("Current version is already the latest version (" + latestVersion.getId() + ")");
        }
        Installer.update(Versions.getLatest());
    }

    public static void update(Version version) throws Exception {
        Installer.setIsUpdating(true);
        try {
            Versions.clearCache();
            Version currentVersion = Versions.getCurrent();
            if (currentVersion == null || version.isCurrent()) {
                return;
            }
            if (version.isInstalled()) {
                Versions.setCurrent(version);
            } else {
                version.getInstaller().install();
            }
            boolean wasRunning = false;
            if (DaemonLoader.hasInstance(currentVersion)) {
                wasRunning = DaemonLoader.get(currentVersion).isRunning();
                DaemonLoader.destroy(currentVersion);
            }
            Versions.setCurrent(version);
            if (wasRunning) {
                DaemonLoader.make(version).start();
            }
        }
        finally {
            Installer.setIsUpdating(false);
        }
    }

    private void download() throws Exception {
        VersionFile[] files;
        for (VersionFile file : files = new VersionFile[]{this.version.getFiles().get("daemon")}) {
            logger.info("Downloading from " + file.getUri().toString());
            URL url = new URL(file.getUri().toString());
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            long totalSize = httpConnection.getContentLengthLong();
            int bufferSize = 1024;
            try (BufferedInputStream inputStream = new BufferedInputStream(httpConnection.getInputStream());
                 BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file.getInstallationFile()));){
                int length;
                byte[] buffer = new byte[bufferSize];
                long downloadedSize = 0L;
                while ((length = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, length);
                    double totalPercentageDownloaded = (double)(downloadedSize += (long)length) / (double)totalSize * 100.0 / (double)files.length;
                    this.onDownloadProgress(totalPercentageDownloaded, file);
                }
            }
            if (Application.args.bypassVersionIntegrityValidation.booleanValue() || file.sha1ChecksumMatches().booleanValue()) continue;
            throw new InvalidSHA1ChecksumException("Invalid SHA1 checksum " + file.getSHA1Checksum());
        }
    }

    protected void onDownloadProgress(double totalPercentageDownloaded, VersionFile file) {
    }

    public static boolean isInProgress() {
        return Installer.isInstalling() || Installer.isUninstalling();
    }

    public static boolean isInstalling() {
        return isInstalling;
    }

    private static void setIsInstalling(boolean isInstalling) {
        Installer.isInstalling = isInstalling;
    }

    public static boolean isUninstalling() {
        return isUninstalling;
    }

    private static void setIsUninstalling(boolean isUninstalling) {
        Installer.isUninstalling = isUninstalling;
    }

    public static boolean isUpdating() {
        return isUpdating;
    }

    private static void setIsUpdating(boolean isUpdating) {
        Installer.isUpdating = isUpdating;
    }
}

