/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.version.file;

import com.gamedash.daemon.wrapper.version.Version;
import com.gamedash.daemon.wrapper.version.file.VersionFile;
import com.gamedash.daemon.wrapper.version.file.VersionFileIntegrityValidationResult;
import java.util.ArrayList;
import java.util.List;

public class VersionFiles {
    private final Version version;
    private final List<VersionFile> files = new ArrayList<VersionFile>();

    public VersionFiles(Version version) {
        this.version = version;
    }

    public List<VersionFile> getAll() {
        return this.files;
    }

    public List<VersionFile> getInstalled() {
        ArrayList<VersionFile> installed = new ArrayList<VersionFile>();
        for (VersionFile file : this.getAll()) {
            if (!file.isInstalled().booleanValue()) continue;
            installed.add(file);
        }
        return installed;
    }

    public VersionFile get(String name) {
        for (VersionFile file : this.getAll()) {
            if (!file.getName().equals(name)) continue;
            return file;
        }
        return null;
    }

    public void add(VersionFile file) {
        this.files.add(file);
    }

    public VersionFileIntegrityValidationResult validateIntegrity() throws Exception {
        if (!this.version.isInstalled()) {
            throw new Exception("Version " + this.version.getId() + " is not installed");
        }
        VersionFile daemonFile = this.get("daemon");
        if (daemonFile == null || !daemonFile.isInstalled().booleanValue() || !daemonFile.compareSHA1Checksum(daemonFile.getInstallationFile()).booleanValue()) {
            return new VersionFileIntegrityValidationResult(false, daemonFile);
        }
        return new VersionFileIntegrityValidationResult(true);
    }
}

