/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.version.file;

import com.gamedash.daemon.wrapper.dependencies.common.dataTypes.Uri;
import com.gamedash.daemon.wrapper.dependencies.common.helpers.fileSystem.FileSystemHelpers;
import com.gamedash.daemon.wrapper.version.Version;
import com.gamedash.daemon.wrapper.version.Versions;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class VersionFile {
    private final Version version;
    private final String name;
    private final Uri uri;
    private final String sha1Checksum;

    public VersionFile(Version version, String name, Uri uri, String sha1Checksum) {
        this.version = version;
        this.name = name;
        this.uri = uri;
        this.sha1Checksum = sha1Checksum;
    }

    public String getName() {
        return this.name;
    }

    public Uri getUri() {
        return this.uri;
    }

    public String getSHA1Checksum() {
        return this.sha1Checksum;
    }

    public File getInstallationFile() {
        return new File(Versions.getDirectory() + "/" + this.getName() + "_" + this.version.getId() + ".jar");
    }

    public Boolean isInstalled() {
        return this.getInstallationFile().exists();
    }

    public void uninstall() {
        this.getInstallationFile().delete();
    }

    public Boolean sha1ChecksumMatches() throws Exception {
        return this.compareSHA1Checksum(this.getInstallationFile());
    }

    public Boolean compareSHA1Checksum(File file) throws IOException, NoSuchAlgorithmException {
        return FileSystemHelpers.getSHA1Checksum(file).equalsIgnoreCase(this.getSHA1Checksum());
    }
}

