/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.version.daemon.target;

import com.gamedash.daemon.wrapper.version.Version;
import com.gamedash.daemon.wrapper.version.Versions;
import com.gamedash.daemon.wrapper.version.daemon.target.CustomDaemonPath;
import com.gamedash.daemon.wrapper.version.daemon.target.DaemonTarget;
import java.io.File;

public class DaemonTargetFetcher {
    private Version preferredVersion;

    public DaemonTarget fetch() throws Exception {
        File customFile = DaemonTargetFetcher.getCustomFile();
        if (customFile != null) {
            return DaemonTarget.create(customFile);
        }
        Version version = this.getVersion();
        DaemonTarget target = DaemonTarget.create(version.getFiles().get("daemon").getInstallationFile());
        target.setIsCustom(true);
        return target;
    }

    private Version getVersion() throws Exception {
        Version preferredVersion = this.getPreferredVersion();
        if (preferredVersion != null) {
            return preferredVersion;
        }
        return Versions.getCurrent();
    }

    public Version getPreferredVersion() {
        return this.preferredVersion;
    }

    public void setPreferredVersion(Version version) {
        this.preferredVersion = version;
    }

    public static DaemonTargetFetcher create() {
        return new DaemonTargetFetcher();
    }

    private static File getCustomFile() throws Exception {
        String path = CustomDaemonPath.getConfigured();
        if (path == null) {
            return null;
        }
        return new File(path);
    }
}

