/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.version.daemon.loader;

import com.gamedash.daemon.wrapper.Application;
import com.gamedash.daemon.wrapper.dependencies.common.authentication.token.AuthenticationToken;
import com.gamedash.daemon.wrapper.dependencies.common.cache.CachedValue;
import com.gamedash.daemon.wrapper.dependencies.common.development.DevelopmentMode;
import com.gamedash.daemon.wrapper.dependencies.common.fileSystem.FileSystem;
import com.gamedash.daemon.wrapper.dependencies.common.network.Network;
import com.gamedash.daemon.wrapper.version.Version;
import com.gamedash.daemon.wrapper.version.Versions;
import com.gamedash.daemon.wrapper.version.daemon.loader.DaemonClassLoader;
import com.gamedash.daemon.wrapper.version.daemon.loader.DaemonClassNotFoundException;
import com.gamedash.daemon.wrapper.version.daemon.loader.DaemonLoaderException;
import com.gamedash.daemon.wrapper.version.daemon.target.DaemonTarget;
import com.gamedash.daemon.wrapper.version.daemon.target.DaemonTargetFetcher;
import java.io.File;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonLoader {
    private static final Logger logger = LoggerFactory.getLogger(DaemonLoader.class);
    private static final Map<String, DaemonLoader> loaders = new HashMap<String, DaemonLoader>();
    private final DaemonClassLoader classLoader;
    private final Version version;
    private final CachedValue<DaemonTarget> target = new CachedValue();
    private boolean isRunning = false;

    public DaemonLoader(Version version) {
        this.version = version;
        this.classLoader = new DaemonClassLoader(this);
    }

    public void start() throws Exception {
        if (this.isRunning()) {
            throw new DaemonLoaderException("Already running");
        }
        DaemonTarget target = this.getTarget();
        File file = target.getFile();
        logger.info("Loading daemon from " + file.getPath());
        try {
            Class<?> applicationClass = this.getClassLoader().getClass("com.gamedash.daemon.Application");
            Object applicationClassConstructor = applicationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> bridgeClass = this.getClassLoader().getClass("com.gamedash.daemon.WrapperBridge");
            Object bridgeClassConstructor = bridgeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            bridgeClass.getMethod("setRootDirectory", File.class).invoke(bridgeClassConstructor, FileSystem.getRootDirectory());
            bridgeClass.getMethod("setVersion", String.class).invoke(bridgeClassConstructor, this.version.getId());
            Method runMethod = applicationClass.getMethod("run", String[].class);
            runMethod.invoke(applicationClassConstructor, new Object[]{this.getArgs().toArray(new String[0])});
        }
        catch (ClassNotFoundException e) {
            throw new DaemonClassNotFoundException(MessageFormat.format("Could not load class ({0}) from daemon {1}", e.getMessage(), file.getPath()));
        }
        this.setIsRunning(true);
    }

    public void shutdown() throws Exception {
        if (!this.isRunning()) {
            throw new DaemonLoaderException("Not running");
        }
        Class<?> applicationClass = this.getClassLoader().getClass("com.gamedash.daemon.Application");
        Method method = applicationClass.getMethod("shutdown", new Class[0]);
        method.invoke(applicationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
        this.getClassLoader().clear();
        this.setIsRunning(false);
    }

    public void restart() throws Exception {
        if (this.isRunning()) {
            this.shutdown();
        }
        this.start();
    }

    public void setAuthenticationToken(AuthenticationToken token) throws Exception {
        Class<?> classObject = this.getClassLoader().getClass("com.gamedash.daemon.Application");
        Method runMethod = classObject.getMethod("setAuthenticationToken", String.class);
        runMethod.invoke(classObject.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), token.toString());
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void setIsRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public DaemonTarget getTarget() throws Exception {
        return this.target.handle(() -> {
            DaemonTargetFetcher fetcher = DaemonTargetFetcher.create();
            fetcher.setPreferredVersion(this.version);
            return fetcher.fetch();
        });
    }

    private List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (DevelopmentMode.isEnabled()) {
            args.add("-dev");
        }
        if (Application.args.apiServerPort != null) {
            args.add("-api-server-port");
            args.add(Integer.toString(Application.args.apiServerPort));
        }
        if (Application.args.apiClientSecure != null) {
            args.add("-api-client-secure");
            args.add(Application.args.apiClientSecure != false ? "true" : "false");
        }
        if (Application.args.apiClientDomain != null) {
            args.add("-api-client-domain");
            args.add(Application.args.apiClientDomain);
        }
        if (Application.args.apiClientVersion != null) {
            args.add("-api-client-version");
            args.add(Application.args.apiClientVersion);
        }
        if (Application.args.installOnly.booleanValue()) {
            args.add("-install-only");
        }
        if (Application.args.shouldUninstall.booleanValue()) {
            args.add("-uninstall");
        }
        if (Application.args.relayOnly.booleanValue()) {
            args.add("-relay-only");
        }
        if (Application.args.installerApiSecure != null) {
            args.add("-installer-api-secure");
            args.add(Application.args.installerApiSecure != false ? "true" : "false");
        }
        if (Application.args.installerApiDomain != null) {
            args.add("-installer-api-domain");
            args.add(Application.args.installerApiDomain);
        }
        if (Application.args.installerAuthenticationToken != null) {
            args.add("-installer-authentication-token");
            args.add(Application.args.installerAuthenticationToken);
        }
        if (Application.args.relayServerPort != null) {
            args.add("-relay-server-port");
            args.add(Application.args.relayServerPort.toString());
        }
        if (Application.args.installerKeyStoreFile != null) {
            args.add("-installer-keystore-file");
            args.add(Application.args.installerKeyStoreFile);
        }
        if (Application.args.installerKeyStorePassword != null) {
            args.add("-installer-keystore-password");
            args.add(Application.args.installerKeyStorePassword);
        }
        if (Application.args.installerKeyStoreIsSelfSigned != null) {
            args.add("-installer-keystore-self-signed");
        }
        if (Application.args.logApiClient.booleanValue()) {
            args.add("-log-api-client");
        }
        if (Application.args.ignoreNodeStatusHandshake != null) {
            args.add("-ignore-node-status-handshake");
        }
        if (Application.args.logApiRequests.booleanValue()) {
            args.add("-log-api-requests");
        }
        args.add("-ip");
        args.add(Network.getIp().getHostAddress());
        return args;
    }

    private DaemonClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static List<DaemonLoader> getAll() {
        ArrayList<DaemonLoader> loaders = new ArrayList<DaemonLoader>();
        for (Map.Entry<String, DaemonLoader> entry : DaemonLoader.loaders.entrySet()) {
            loaders.add(entry.getValue());
        }
        return loaders;
    }

    public static DaemonLoader get(Version version) throws DaemonLoaderException {
        if (!DaemonLoader.hasInstance(version)) {
            throw new DaemonLoaderException("Application loader for version " + version.getId() + " does not exist");
        }
        return loaders.get(version.getId());
    }

    public static boolean hasInstance(Version version) {
        return loaders.containsKey(version.getId());
    }

    public static DaemonLoader make() throws Exception {
        return DaemonLoader.make(Versions.getPrimaryVersion());
    }

    public static DaemonLoader make(Version version) throws DaemonLoaderException {
        if (DaemonLoader.hasInstance(version)) {
            throw new DaemonLoaderException("Application loader for version " + version.getId() + " already exists");
        }
        DaemonLoader applicationLoader = new DaemonLoader(version);
        loaders.put(version.getId(), applicationLoader);
        return applicationLoader;
    }

    public static void destroy(Version version) throws Exception {
        if (!DaemonLoader.hasInstance(version)) {
            throw new DaemonLoaderException("Application loader for version " + version.getId() + " does not exist");
        }
        DaemonLoader applicationLoader = DaemonLoader.get(version);
        if (applicationLoader.isRunning()) {
            applicationLoader.shutdown();
        }
        loaders.put(version.getId(), null);
        loaders.remove(version.getId());
    }
}

