/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.version.daemon.loader;

import com.gamedash.daemon.wrapper.dependencies.common.cache.CachedValue;
import com.gamedash.daemon.wrapper.version.daemon.loader.DaemonLoader;
import com.gamedash.daemon.wrapper.version.daemon.target.DaemonTarget;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class DaemonClassLoader {
    private final DaemonLoader loader;
    private final Map<String, Class<?>> classes = new HashMap();
    private CachedValue<URLClassLoader> classLoader = new CachedValue();

    public DaemonClassLoader(DaemonLoader loader) {
        this.loader = loader;
    }

    public Class<?> getClass(String path) throws Exception {
        Class<?> clazz = this.classes.get(path);
        if (clazz == null) {
            clazz = this.load(path);
            this.storeClass(path, clazz);
        }
        return clazz;
    }

    public void storeClass(String path, Class<?> clazz) {
        this.classes.put(path, clazz);
    }

    public Class<?> load(String path) throws Exception {
        return Class.forName(path, true, this.getClassLoader());
    }

    public void clear() {
        this.classes.clear();
        this.classLoader.clear();
    }

    private URLClassLoader getClassLoader() throws Exception {
        return this.classLoader.handle(() -> {
            DaemonTarget target = this.loader.getTarget();
            File file = target.getFile();
            return new URLClassLoader(new URL[]{file.toURI().toURL()}, this.getClass().getClassLoader());
        });
    }
}

