/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.version;

import com.gamedash.daemon.wrapper.Application;
import com.gamedash.daemon.wrapper.dependencies.common.config.Config;
import com.gamedash.daemon.wrapper.dependencies.common.config.transformer.ListTransformer;
import com.gamedash.daemon.wrapper.dependencies.common.fileSystem.FileSystem;
import com.gamedash.daemon.wrapper.version.Version;
import com.gamedash.daemon.wrapper.version.daemon.target.CustomDaemonPath;
import com.gamedash.daemon.wrapper.version.file.VersionFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Versions {
    public static final String minimumVersion = "13.0.0";

    public static List<Version> getAll() throws Exception {
        List<com.gamedash.daemon.wrapper.dependencies.common.version.Version> parentVersions = com.gamedash.daemon.wrapper.dependencies.common.version.Versions.getAll();
        ArrayList<Version> versions = new ArrayList<Version>();
        parentVersions.forEach(parentVersion -> {
            Version version = new Version(parentVersion.getId());
            version.setIsLatest(parentVersion.isLatest());
            parentVersion.getFiles().getAll().forEach(parentFile -> version.getFiles().add(new VersionFile(version, parentFile.getName(), parentFile.getUri(), parentFile.getSHA1Checksum())));
            parentVersion.getCompatible().forEach(compatibleParentVersion -> version.addCompatible(new Version(compatibleParentVersion.getId())));
            versions.add(version);
        });
        return versions;
    }

    public static Version get(String id) throws Exception {
        for (Version version : Versions.getAll()) {
            if (!version.isEqualTo(id)) continue;
            return version;
        }
        return null;
    }

    public static Version getLatest() throws Exception {
        return Versions.get(com.gamedash.daemon.wrapper.dependencies.common.version.Versions.getLatest().getId());
    }

    public static List<Version> getInstalled() throws Exception {
        ArrayList<Version> versions = new ArrayList<Version>();
        if (Config.getFile("version.properties").valueExists("versions")) {
            for (String id : Config.getFile("version.properties").getValueAsList("versions")) {
                Version version = Versions.get(id);
                if (version == null) continue;
                versions.add(version);
            }
        }
        return versions;
    }

    public static void addInstalled(Version version) throws Exception {
        List<Version> versions = Versions.getInstalled();
        versions.add(version);
        Versions.setInstalled(versions);
    }

    public static void removeInstalled(Version version) throws Exception {
        List<Version> versions = Versions.getInstalled().stream().filter(_version -> !_version.isEqualTo(version)).collect(Collectors.toList());
        Versions.setInstalled(versions);
    }

    public static void setInstalled(List<Version> versions) throws Exception {
        List versionIds = versions.stream().map(version -> String.valueOf(version.getId())).collect(Collectors.toList());
        Config.getFile("version.properties").setValue("versions", versionIds, new ListTransformer());
    }

    public static Version getCurrent() throws Exception {
        if (!Config.getFile("version.properties").valueExists("current")) {
            return null;
        }
        return Versions.get(Config.getFile("version.properties").getValue("current"));
    }

    public static Boolean hasCurrent() throws Exception {
        return Config.getFile("version.properties").valueExists("current");
    }

    public static void setCurrent(Version target) throws Exception {
        Config.getFile("version.properties").setValue("current", target.getId());
    }

    public static Version getPrimaryVersion() throws Exception {
        Version currentVersion = Versions.getCurrent();
        if (currentVersion != null) {
            return currentVersion;
        }
        return Versions.getLatest();
    }

    public static File getDirectory() {
        return new File(FileSystem.getRootDirectory().getPath() + "/versions");
    }

    public static void clearCache() {
        com.gamedash.daemon.wrapper.dependencies.common.version.Versions.clearCache();
    }

    public static boolean shouldBypassVersionIntegrityValidation() throws Exception {
        return Application.args.bypassVersionIntegrityValidation != false && CustomDaemonPath.getConfigured() != null;
    }
}

