/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.version;

import com.gamedash.daemon.wrapper.dependencies.common.version.SemverVersion;
import com.gamedash.daemon.wrapper.version.Versions;
import com.gamedash.daemon.wrapper.version.file.VersionFiles;
import com.gamedash.daemon.wrapper.version.installer.Installer;
import java.util.ArrayList;
import java.util.List;

public class Version
implements SemverVersion {
    private final String id;
    private final VersionFiles files;
    private final Installer installer;
    private final List<Version> compatible = new ArrayList<Version>();
    private boolean isLatest = false;

    public Version(String id) {
        this.id = id;
        this.files = new VersionFiles(this);
        this.installer = new Installer(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean isInstalled() throws Exception {
        for (Version version : Versions.getInstalled()) {
            if (!version.isEqualTo(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isSupported() {
        return this.isEqualTo("13.0.0") || this.isGreaterThan("13.0.0");
    }

    public boolean isCurrent() throws Exception {
        Version currentVersion = Versions.getCurrent();
        return currentVersion != null && currentVersion.isEqualTo(this);
    }

    public Boolean isLatest() {
        return this.isLatest;
    }

    public void setIsLatest(Boolean isLatest) {
        this.isLatest = isLatest;
    }

    public List<Version> getCompatible() {
        return this.compatible;
    }

    public void addCompatible(Version version) {
        this.compatible.add(version);
    }

    public VersionFiles getFiles() {
        return this.files;
    }

    public Installer getInstaller() {
        return this.installer;
    }
}

