/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.shutdown;

import com.gamedash.daemon.wrapper.dependencies.common.initialization.InitializerImplementationsRegistry;
import com.gamedash.daemon.wrapper.dependencies.common.initialization.implementation.IInitializerImplementation;
import com.gamedash.daemon.wrapper.dependencies.org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownManager {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownManager.class);
    private static boolean hasRegisteredHook = false;
    private static boolean isShuttingDown = false;

    public static void run() {
        if (ShutdownManager.isShuttingDown()) {
            return;
        }
        ShutdownManager.setIsShuttingDown(true);
        ShutdownManager.destroyInitializers();
    }

    public static void registerHook() throws Exception {
        if (ShutdownManager.hasRegisteredHook()) {
            throw new Exception("Shutdown hook has already been registered");
        }
        ShutdownManager.setHasRegisteredHook(true);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                ShutdownManager.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
    }

    public static boolean isShuttingDown() {
        return isShuttingDown;
    }

    private static void setIsShuttingDown(boolean shuttingDown) {
        isShuttingDown = shuttingDown;
    }

    public static boolean hasRegisteredHook() {
        return hasRegisteredHook;
    }

    private static void setHasRegisteredHook(boolean hasRegisteredHook) {
        ShutdownManager.hasRegisteredHook = hasRegisteredHook;
    }

    private static void destroyInitializers() {
        for (IInitializerImplementation implementation : InitializerImplementationsRegistry.getImplementations()) {
            try {
                if (!implementation.isAvailable()) continue;
                implementation.destroy();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        }
    }
}

