/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.initialization.implementations.services;

import com.gamedash.daemon.wrapper.Application;
import com.gamedash.daemon.wrapper.dependencies.common.initialization.implementation.InitializerImplementation;
import com.gamedash.daemon.wrapper.dependencies.common.version.VersionNotFoundException;
import com.gamedash.daemon.wrapper.dependencies.me.tongfei.progressbar.ProgressBar;
import com.gamedash.daemon.wrapper.version.Version;
import com.gamedash.daemon.wrapper.version.Versions;
import com.gamedash.daemon.wrapper.version.daemon.target.CustomDaemonPath;
import com.gamedash.daemon.wrapper.version.file.VersionFile;
import com.gamedash.daemon.wrapper.version.file.VersionFileIntegrityValidationResult;
import com.gamedash.daemon.wrapper.version.installer.Installer;
import com.gamedash.daemon.wrapper.version.installer.InvalidSHA1ChecksumException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInitializer
extends InitializerImplementation {
    private static final Logger logger = LoggerFactory.getLogger(VersionInitializer.class);

    @Override
    public void initialize() throws Exception {
        String customDaemonPath;
        if (!Versions.getDirectory().exists()) {
            Versions.getDirectory().mkdir();
        }
        if ((customDaemonPath = CustomDaemonPath.getConfigured()) == null) {
            this.determineCurrentVersion();
            this.acquireCurrentVersion();
        } else {
            logger.info("Skipping version checks because a custom daemon path has been defined");
        }
    }

    private void determineCurrentVersion() throws Exception {
        Version version;
        if (Application.args.versionId != null) {
            version = Versions.get(Application.args.versionId);
            if (version == null) {
                throw new VersionNotFoundException("Version not found");
            }
            Versions.setCurrent(version);
        } else if (Application.args.latestVersion.booleanValue()) {
            version = Versions.getLatest();
            if (version == null) {
                throw new VersionNotFoundException("Could not find latest version");
            }
            Versions.setCurrent(version);
        }
        version = Versions.getPrimaryVersion();
        if (version == null) {
            throw new VersionNotFoundException("Could not find primary version");
        }
        Versions.setCurrent(version);
    }

    private void acquireCurrentVersion() throws Exception {
        Version currentVersion = Versions.getCurrent();
        logger.info("Using version " + currentVersion.getId() + (currentVersion.isLatest() != false ? " (latest)" : ""));
        if (!currentVersion.isInstalled()) {
            logger.info("Installing version " + currentVersion.getId());
            this.installVersion(currentVersion);
        } else if (!Versions.shouldBypassVersionIntegrityValidation()) {
            VersionFileIntegrityValidationResult integrityValidationResult = currentVersion.getFiles().validateIntegrity();
            if (!integrityValidationResult.isValid().booleanValue()) {
                logger.info("Currently installed version did not pass integrity validation. Re-installing...");
                currentVersion.getInstaller().uninstall();
                try {
                    this.installVersion(currentVersion);
                }
                catch (InvalidSHA1ChecksumException e) {
                    logger.error("Could not re-install because the SHA1 checksum does not match the stored checksum. To temporarily fix this issue, consider downgrading to an earlier version.");
                }
            }
        } else {
            logger.info("Skipping version integrity checks because of a custom daemon path that has been defined");
        }
    }

    private void installVersion(Version version) throws Exception {
        try (final ProgressBar progressBar = new ProgressBar("Downloading...", 100L);){
            new Installer(version){

                @Override
                protected void onDownloadProgress(double totalPercentageDownloaded, VersionFile file) {
                    progressBar.stepTo(Double.valueOf(Math.ceil(totalPercentageDownloaded)).longValue());
                    progressBar.setExtraMessage(file.getName());
                }
            }.install();
        }
    }
}

