/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.initialization.implementations.services;

import com.gamedash.daemon.wrapper.dependencies.common.authentication.Authentication;
import com.gamedash.daemon.wrapper.dependencies.common.authentication.AuthenticationResult;
import com.gamedash.daemon.wrapper.dependencies.common.initialization.Initializer;
import com.gamedash.daemon.wrapper.dependencies.common.initialization.implementation.IInitializerImplementation;
import com.gamedash.daemon.wrapper.dependencies.common.initialization.implementation.InitializerImplementation;
import com.gamedash.daemon.wrapper.dependencies.common.installer.Installer;
import com.gamedash.daemon.wrapper.initialization.implementations.services.DaemonInitializer;
import com.gamedash.daemon.wrapper.initialization.implementations.services.HttpsApiServiceInitializer;
import com.gamedash.daemon.wrapper.initialization.implementations.services.VersionInitializer;
import java.util.ArrayList;
import java.util.List;

public class ServicesInitializer
extends InitializerImplementation {
    private final Initializer initializer = new Initializer(this.getImplementations());

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.initializeVersions();
        this.initializer.initialize();
    }

    @Override
    public void destroy() throws Exception {
        super.destroy();
        this.initializer.destroy();
    }

    @Override
    public boolean isAvailable() throws Exception {
        if (!Installer.isInstalled()) {
            return true;
        }
        AuthenticationResult result = Authentication.authenticate();
        return result.isValid();
    }

    private void initializeVersions() throws Exception {
        VersionInitializer versionInitializer = new VersionInitializer();
        if (versionInitializer.isAvailable()) {
            versionInitializer.initialize();
        }
    }

    private List<IInitializerImplementation> getImplementations() {
        return new ArrayList<IInitializerImplementation>(){
            {
                this.add(new HttpsApiServiceInitializer());
                this.add(new DaemonInitializer());
            }
        };
    }
}

