/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.initialization.implementations.services;

import com.gamedash.daemon.wrapper.dependencies.common.initialization.implementation.InitializerImplementation;
import com.gamedash.daemon.wrapper.version.Version;
import com.gamedash.daemon.wrapper.version.Versions;
import com.gamedash.daemon.wrapper.version.daemon.loader.DaemonLoader;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonInitializer
extends InitializerImplementation {
    public static final Logger logger = LoggerFactory.getLogger(DaemonInitializer.class);

    @Override
    public void initialize() throws Exception {
        Version version = Versions.getPrimaryVersion();
        logger.info(MessageFormat.format("Initializing daemon version {0}", version.getId()));
        DaemonLoader loader = DaemonLoader.make(version);
        loader.start();
    }

    @Override
    public void destroy() throws Exception {
        for (DaemonLoader loader : DaemonLoader.getAll()) {
            if (!loader.isRunning()) continue;
            loader.shutdown();
        }
    }
}

