/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.spark.staticfiles;

import com.gamedash.daemon.wrapper.dependencies.spark.resource.AbstractFileResolvingResource;
import com.gamedash.daemon.wrapper.dependencies.spark.resource.AbstractResourceHandler;
import com.gamedash.daemon.wrapper.dependencies.spark.resource.ClassPathResourceHandler;
import com.gamedash.daemon.wrapper.dependencies.spark.resource.ExternalResource;
import com.gamedash.daemon.wrapper.dependencies.spark.resource.ExternalResourceHandler;
import com.gamedash.daemon.wrapper.dependencies.spark.staticfiles.DirectoryTraversal;
import com.gamedash.daemon.wrapper.dependencies.spark.staticfiles.MimeType;
import com.gamedash.daemon.wrapper.dependencies.spark.utils.Assert;
import com.gamedash.daemon.wrapper.dependencies.spark.utils.GzipUtils;
import com.gamedash.daemon.wrapper.dependencies.spark.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFilesConfiguration {
    private final Logger LOG = LoggerFactory.getLogger(StaticFilesConfiguration.class);
    private List<AbstractResourceHandler> staticResourceHandlers = null;
    private boolean staticResourcesSet = false;
    private boolean externalStaticResourcesSet = false;
    public static StaticFilesConfiguration servletInstance = new StaticFilesConfiguration();
    private Map<String, String> customHeaders = new HashMap<String, String>();

    public boolean consume(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        try {
            if (this.consumeWithFileResourceHandlers(httpRequest, httpResponse)) {
                return true;
            }
        }
        catch (DirectoryTraversal.DirectoryTraversalDetection directoryTraversalDetection) {
            httpResponse.setStatus(400);
            httpResponse.getWriter().write("Bad request");
            httpResponse.getWriter().flush();
            this.LOG.warn(directoryTraversalDetection.getMessage() + " directory traversal detection for path: " + httpRequest.getPathInfo());
        }
        return false;
    }

    private boolean consumeWithFileResourceHandlers(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (this.staticResourceHandlers != null) {
            for (AbstractResourceHandler staticResourceHandler : this.staticResourceHandlers) {
                AbstractFileResolvingResource resource = staticResourceHandler.getResource(httpRequest);
                if (resource == null || !resource.isReadable()) continue;
                if (MimeType.shouldGuess()) {
                    httpResponse.setHeader("Content-Type", MimeType.fromResource(resource));
                }
                this.customHeaders.forEach(httpResponse::setHeader);
                try (InputStream inputStream = resource.getInputStream();
                     OutputStream wrappedOutputStream = GzipUtils.checkAndWrap(httpRequest, httpResponse, false);){
                    IOUtils.copy(inputStream, wrappedOutputStream);
                }
                return true;
            }
        }
        return false;
    }

    public void clear() {
        if (this.staticResourceHandlers != null) {
            this.staticResourceHandlers.clear();
            this.staticResourceHandlers = null;
        }
        this.staticResourcesSet = false;
        this.externalStaticResourcesSet = false;
    }

    public boolean isStaticResourcesSet() {
        return this.staticResourcesSet;
    }

    public boolean isExternalStaticResourcesSet() {
        return this.externalStaticResourcesSet;
    }

    public synchronized void configure(String folder) {
        Assert.notNull(folder, "'folder' must not be null");
        if (!this.staticResourcesSet) {
            if (this.staticResourceHandlers == null) {
                this.staticResourceHandlers = new ArrayList<AbstractResourceHandler>();
            }
            this.staticResourceHandlers.add(new ClassPathResourceHandler(folder, "index.html"));
            this.LOG.info("StaticResourceHandler configured with folder = " + folder);
            this.staticResourcesSet = true;
        }
    }

    public synchronized void configureExternal(String folder) {
        Assert.notNull(folder, "'folder' must not be null");
        if (!this.externalStaticResourcesSet) {
            try {
                ExternalResource resource = new ExternalResource(folder);
                if (!resource.getFile().isDirectory()) {
                    this.LOG.error("External Static resource location must be a folder");
                    return;
                }
                if (this.staticResourceHandlers == null) {
                    this.staticResourceHandlers = new ArrayList<AbstractResourceHandler>();
                }
                this.staticResourceHandlers.add(new ExternalResourceHandler(folder, "index.html"));
                this.LOG.info("External StaticResourceHandler configured with folder = " + folder);
            }
            catch (IOException e) {
                this.LOG.error("Error when creating external StaticResourceHandler", e);
            }
            this.externalStaticResourcesSet = true;
        }
    }

    public static StaticFilesConfiguration create() {
        return new StaticFilesConfiguration();
    }

    public void setExpireTimeSeconds(long expireTimeSeconds) {
        this.customHeaders.put("Cache-Control", "private, max-age=" + expireTimeSeconds);
        this.customHeaders.put("Expires", new Date(System.currentTimeMillis() + expireTimeSeconds * 1000L).toString());
    }

    public void putCustomHeaders(Map<String, String> headers) {
        this.customHeaders.putAll(headers);
    }

    public void putCustomHeader(String key, String value) {
        this.customHeaders.put(key, value);
    }
}

