/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.spark.resource;

import com.gamedash.daemon.wrapper.dependencies.spark.resource.AbstractFileResolvingResource;
import com.gamedash.daemon.wrapper.dependencies.spark.resource.AbstractResourceHandler;
import com.gamedash.daemon.wrapper.dependencies.spark.resource.ExternalResource;
import com.gamedash.daemon.wrapper.dependencies.spark.resource.UriPath;
import com.gamedash.daemon.wrapper.dependencies.spark.staticfiles.DirectoryTraversal;
import com.gamedash.daemon.wrapper.dependencies.spark.utils.Assert;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalResourceHandler
extends AbstractResourceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalResourceHandler.class);
    private final String baseResource;
    private String welcomeFile;

    public ExternalResourceHandler(String baseResource) {
        this(baseResource, null);
    }

    public ExternalResourceHandler(String baseResource, String welcomeFile) {
        Assert.notNull(baseResource);
        this.baseResource = baseResource;
        this.welcomeFile = welcomeFile;
    }

    @Override
    protected AbstractFileResolvingResource getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        try {
            path = UriPath.canonical(path);
            String addedPath = ExternalResourceHandler.addPaths(this.baseResource, path);
            ExternalResource resource = new ExternalResource(addedPath);
            if (resource.exists() && resource.isDirectory()) {
                resource = this.welcomeFile != null ? new ExternalResource(ExternalResourceHandler.addPaths(resource.getPath(), this.welcomeFile)) : null;
            }
            if (resource != null && resource.exists()) {
                DirectoryTraversal.protectAgainstForExternal(resource.getPath(), this.baseResource);
                return resource;
            }
            return null;
        }
        catch (DirectoryTraversal.DirectoryTraversalDetection directoryTraversalDetection) {
            throw directoryTraversalDetection;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getClass().getSimpleName() + " when trying to get resource. " + e.getMessage());
            }
            return null;
        }
    }
}

