/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.spark.http.matching;

import com.gamedash.daemon.wrapper.dependencies.spark.CustomErrorPages;
import com.gamedash.daemon.wrapper.dependencies.spark.ExceptionMapper;
import com.gamedash.daemon.wrapper.dependencies.spark.HaltException;
import com.gamedash.daemon.wrapper.dependencies.spark.RequestResponseFactory;
import com.gamedash.daemon.wrapper.dependencies.spark.Response;
import com.gamedash.daemon.wrapper.dependencies.spark.embeddedserver.jetty.HttpRequestWrapper;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.AfterAfterFilters;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.AfterFilters;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.BeforeFilters;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.Body;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.GeneralError;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.Halt;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.RequestWrapper;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.ResponseWrapper;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.RouteContext;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.Routes;
import com.gamedash.daemon.wrapper.dependencies.spark.route.HttpMethod;
import com.gamedash.daemon.wrapper.dependencies.spark.serialization.SerializerChain;
import com.gamedash.daemon.wrapper.dependencies.spark.staticfiles.StaticFilesConfiguration;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatcherFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(MatcherFilter.class);
    private static final String ACCEPT_TYPE_REQUEST_MIME_HEADER = "Accept";
    private static final String HTTP_METHOD_OVERRIDE_HEADER = "X-HTTP-Method-Override";
    private final StaticFilesConfiguration staticFiles;
    private com.gamedash.daemon.wrapper.dependencies.spark.route.Routes routeMatcher;
    private SerializerChain serializerChain;
    private ExceptionMapper exceptionMapper;
    private boolean externalContainer;
    private boolean hasOtherHandlers;

    public MatcherFilter(com.gamedash.daemon.wrapper.dependencies.spark.route.Routes routeMatcher, StaticFilesConfiguration staticFiles, ExceptionMapper exceptionMapper, boolean externalContainer, boolean hasOtherHandlers) {
        this.routeMatcher = routeMatcher;
        this.staticFiles = staticFiles;
        this.exceptionMapper = exceptionMapper;
        this.externalContainer = externalContainer;
        this.hasOtherHandlers = hasOtherHandlers;
        this.serializerChain = new SerializerChain();
    }

    @Override
    public void init(FilterConfig config) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        boolean consumedByStaticFile = this.staticFiles.consume(httpRequest, httpResponse);
        if (consumedByStaticFile) {
            return;
        }
        String method = this.getHttpMethodFrom(httpRequest);
        String httpMethodStr = method.toLowerCase();
        String uri = httpRequest.getRequestURI();
        String acceptType = httpRequest.getHeader(ACCEPT_TYPE_REQUEST_MIME_HEADER);
        Body body = Body.create();
        RequestWrapper requestWrapper = RequestWrapper.create();
        ResponseWrapper responseWrapper = ResponseWrapper.create();
        Response response = RequestResponseFactory.create(httpResponse);
        HttpMethod httpMethod = HttpMethod.get(httpMethodStr);
        RouteContext context = RouteContext.create().withMatcher(this.routeMatcher).withHttpRequest(httpRequest).withUri(uri).withAcceptType(acceptType).withBody(body).withRequestWrapper(requestWrapper).withResponseWrapper(responseWrapper).withResponse(response).withHttpMethod(httpMethod);
        try {
            try {
                BeforeFilters.execute(context);
                Routes.execute(context);
                AfterFilters.execute(context);
            }
            catch (HaltException halt) {
                Halt.modify(httpResponse, body, halt);
            }
            catch (Exception generalException) {
                GeneralError.modify(httpRequest, httpResponse, body, requestWrapper, responseWrapper, this.exceptionMapper, generalException);
            }
            if (body.notSet() && responseWrapper.isRedirected()) {
                body.set("");
            }
            if (body.notSet() && this.hasOtherHandlers && servletRequest instanceof HttpRequestWrapper) {
                ((HttpRequestWrapper)servletRequest).notConsumed(true);
                return;
            }
            if (body.notSet()) {
                LOG.info("The requested route [{}] has not been mapped in Spark for {}: [{}]", uri, ACCEPT_TYPE_REQUEST_MIME_HEADER, acceptType);
                httpResponse.setStatus(404);
                if (CustomErrorPages.existsFor(404)) {
                    requestWrapper.setDelegate(RequestResponseFactory.create(httpRequest));
                    responseWrapper.setDelegate(RequestResponseFactory.create(httpResponse));
                    body.set(CustomErrorPages.getFor(404, requestWrapper, responseWrapper));
                } else {
                    body.set(String.format("<html><body><h2>404 Not found</h2></body></html>", new Object[0]));
                }
            }
        }
        finally {
            try {
                AfterAfterFilters.execute(context);
            }
            catch (Exception generalException) {
                GeneralError.modify(httpRequest, httpResponse, body, requestWrapper, responseWrapper, this.exceptionMapper, generalException);
            }
        }
        if (body.isSet()) {
            body.serializeTo(httpResponse, this.serializerChain, httpRequest);
        } else if (chain != null) {
            chain.doFilter(httpRequest, httpResponse);
        }
    }

    private String getHttpMethodFrom(HttpServletRequest httpRequest) {
        String method = httpRequest.getHeader(HTTP_METHOD_OVERRIDE_HEADER);
        if (method == null) {
            method = httpRequest.getMethod();
        }
        return method;
    }

    @Override
    public void destroy() {
    }
}

