/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.spark.http.matching;

import com.gamedash.daemon.wrapper.dependencies.spark.CustomErrorPages;
import com.gamedash.daemon.wrapper.dependencies.spark.ExceptionHandlerImpl;
import com.gamedash.daemon.wrapper.dependencies.spark.ExceptionMapper;
import com.gamedash.daemon.wrapper.dependencies.spark.RequestResponseFactory;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.Body;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.RequestWrapper;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.ResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GeneralError {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralError.class);

    GeneralError() {
    }

    static void modify(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Body body, RequestWrapper requestWrapper, ResponseWrapper responseWrapper, ExceptionMapper exceptionMapper, Exception e) {
        ExceptionHandlerImpl handler = exceptionMapper.getHandler(e);
        if (handler != null) {
            handler.handle(e, requestWrapper, responseWrapper);
            String bodyAfterFilter = responseWrapper.getDelegate().body();
            if (bodyAfterFilter != null) {
                body.set(bodyAfterFilter);
            }
        } else {
            LOG.error("", e);
            httpResponse.setStatus(500);
            if (CustomErrorPages.existsFor(500)) {
                requestWrapper.setDelegate(RequestResponseFactory.create(httpRequest));
                responseWrapper.setDelegate(RequestResponseFactory.create(httpResponse));
                body.set(CustomErrorPages.getFor(500, requestWrapper, responseWrapper));
            } else {
                body.set("<html><body><h2>500 Internal Server Error</h2></body></html>");
            }
        }
    }
}

