/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.spark.http.matching;

import com.gamedash.daemon.wrapper.dependencies.spark.serialization.SerializerChain;
import com.gamedash.daemon.wrapper.dependencies.spark.utils.GzipUtils;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class Body {
    private Object content;

    public static Body create() {
        return new Body();
    }

    private Body() {
    }

    public boolean notSet() {
        return this.content == null;
    }

    public boolean isSet() {
        return this.content != null;
    }

    public Object get() {
        return this.content;
    }

    public void set(Object content) {
        this.content = content;
    }

    public void serializeTo(HttpServletResponse httpResponse, SerializerChain serializerChain, HttpServletRequest httpRequest) throws IOException {
        if (!httpResponse.isCommitted()) {
            if (httpResponse.getContentType() == null) {
                httpResponse.setContentType("text/html; charset=utf-8");
            }
            OutputStream responseStream = GzipUtils.checkAndWrap(httpRequest, httpResponse, true);
            serializerChain.process(responseStream, this.content);
            responseStream.flush();
            responseStream.close();
        }
    }
}

