/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.spark.embeddedserver.jetty.websocket;

import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.http.pathmap.PathSpec;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.http.pathmap.ServletPathSpec;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.servlet.ServletContextHandler;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import com.gamedash.daemon.wrapper.dependencies.spark.embeddedserver.jetty.websocket.WebSocketCreatorFactory;
import com.gamedash.daemon.wrapper.dependencies.spark.embeddedserver.jetty.websocket.WebSocketHandlerWrapper;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServletContextHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServletContextHandlerFactory.class);

    public static ServletContextHandler create(Map<String, WebSocketHandlerWrapper> webSocketHandlers, Optional<Integer> webSocketIdleTimeoutMillis) {
        ServletContextHandler webSocketServletContextHandler = null;
        if (webSocketHandlers != null) {
            try {
                webSocketServletContextHandler = new ServletContextHandler(null, "/", true, false);
                WebSocketUpgradeFilter webSocketUpgradeFilter = WebSocketUpgradeFilter.configureContext(webSocketServletContextHandler);
                if (webSocketIdleTimeoutMillis.isPresent()) {
                    webSocketUpgradeFilter.getFactory().getPolicy().setIdleTimeout(webSocketIdleTimeoutMillis.get().intValue());
                }
                NativeWebSocketConfiguration webSocketConfiguration = (NativeWebSocketConfiguration)webSocketServletContextHandler.getServletContext().getAttribute(NativeWebSocketConfiguration.class.getName());
                for (String path : webSocketHandlers.keySet()) {
                    WebSocketCreator webSocketCreator = WebSocketCreatorFactory.create(webSocketHandlers.get(path));
                    webSocketConfiguration.addMapping((PathSpec)new ServletPathSpec(path), webSocketCreator);
                }
            }
            catch (Exception ex) {
                logger.error("creation of websocket context handler failed.", ex);
                webSocketServletContextHandler = null;
            }
        }
        return webSocketServletContextHandler;
    }
}

