/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.spark.embeddedserver.jetty;

import com.gamedash.daemon.wrapper.dependencies.spark.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class HttpRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] cachedBytes;
    private boolean notConsumed = false;

    public HttpRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public boolean notConsumed() {
        return this.notConsumed;
    }

    public void notConsumed(boolean notConsumed) {
        this.notConsumed = notConsumed;
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        HttpServletRequest request = (HttpServletRequest)super.getRequest();
        String transferEncoding = request.getHeader("Transfer-Encoding");
        if ("chunked".equals(transferEncoding)) {
            return super.getInputStream();
        }
        String contentType = request.getHeader("Content-Type");
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            return super.getInputStream();
        }
        if (this.cachedBytes == null) {
            this.cacheInputStream();
        }
        return new CachedServletInputStream();
    }

    private void cacheInputStream() throws IOException {
        this.cachedBytes = IOUtils.toByteArray(super.getInputStream());
    }

    private class CachedServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream byteArrayInputStream;

        public CachedServletInputStream() {
            this.byteArrayInputStream = new ByteArrayInputStream(HttpRequestWrapper.this.cachedBytes);
        }

        @Override
        public int read() {
            return this.byteArrayInputStream.read();
        }

        @Override
        public int available() {
            return this.byteArrayInputStream.available();
        }

        @Override
        public boolean isFinished() {
            return this.available() <= 0;
        }

        @Override
        public boolean isReady() {
            return this.available() >= 0;
        }

        @Override
        public void setReadListener(ReadListener readListener) {
        }
    }
}

