/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.spark.embeddedserver.jetty;

import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.util.thread.ThreadPool;
import com.gamedash.daemon.wrapper.dependencies.spark.ExceptionMapper;
import com.gamedash.daemon.wrapper.dependencies.spark.embeddedserver.EmbeddedServer;
import com.gamedash.daemon.wrapper.dependencies.spark.embeddedserver.EmbeddedServerFactory;
import com.gamedash.daemon.wrapper.dependencies.spark.embeddedserver.jetty.EmbeddedJettyServer;
import com.gamedash.daemon.wrapper.dependencies.spark.embeddedserver.jetty.JettyHandler;
import com.gamedash.daemon.wrapper.dependencies.spark.embeddedserver.jetty.JettyServer;
import com.gamedash.daemon.wrapper.dependencies.spark.embeddedserver.jetty.JettyServerFactory;
import com.gamedash.daemon.wrapper.dependencies.spark.http.matching.MatcherFilter;
import com.gamedash.daemon.wrapper.dependencies.spark.route.Routes;
import com.gamedash.daemon.wrapper.dependencies.spark.staticfiles.StaticFilesConfiguration;

public class EmbeddedJettyFactory
implements EmbeddedServerFactory {
    private final JettyServerFactory serverFactory;
    private ThreadPool threadPool;
    private boolean httpOnly = true;

    public EmbeddedJettyFactory() {
        this.serverFactory = new JettyServer();
    }

    public EmbeddedJettyFactory(JettyServerFactory serverFactory) {
        this.serverFactory = serverFactory;
    }

    @Override
    public EmbeddedServer create(Routes routeMatcher, StaticFilesConfiguration staticFilesConfiguration, ExceptionMapper exceptionMapper, boolean hasMultipleHandler) {
        MatcherFilter matcherFilter = new MatcherFilter(routeMatcher, staticFilesConfiguration, exceptionMapper, false, hasMultipleHandler);
        matcherFilter.init(null);
        JettyHandler handler = new JettyHandler(matcherFilter);
        handler.getSessionCookieConfig().setHttpOnly(this.httpOnly);
        return new EmbeddedJettyServer(this.serverFactory, handler).withThreadPool(this.threadPool);
    }

    public EmbeddedJettyFactory withThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public EmbeddedJettyFactory withHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }
}

