/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.util.platform.linux;

import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.CentralProcessor;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.FileUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.GlobalConfig;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.Memoizer;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ParseUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class ProcUtil {
    public static final String CPUINFO = "/cpuinfo";
    public static final String STAT = "/stat";
    private static final Pattern DIGITS = Pattern.compile("\\d+");
    private static Supplier<String> proc = Memoizer.memoize(ProcUtil::queryProcConfig, TimeUnit.HOURS.toNanos(1L));

    private ProcUtil() {
    }

    public static String getProcPath() {
        return proc.get();
    }

    private static String queryProcConfig() {
        String procPath = GlobalConfig.get("com.gamedash.daemon.wrapper.dependencies.oshi.util.proc.path", "/proc");
        procPath = '/' + procPath.replaceAll("/$|^/", "");
        if (!new File(procPath).exists()) {
            throw new GlobalConfig.PropertyException("com.gamedash.daemon.wrapper.dependencies.oshi.util.proc.path", "The path does not exist");
        }
        return procPath;
    }

    public static double getSystemUptimeSeconds() {
        String uptime = FileUtil.getStringFromFile(ProcUtil.getProcPath() + "/uptime");
        int spaceIndex = uptime.indexOf(32);
        try {
            if (spaceIndex < 0) {
                return 0.0;
            }
            return Double.parseDouble(uptime.substring(0, spaceIndex));
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    public static long[] readSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        List<String> procStat = FileUtil.readFile(ProcUtil.getProcPath() + STAT);
        if (procStat.isEmpty()) {
            return ticks;
        }
        String tickStr = procStat.get(0);
        String[] tickArr = ParseUtil.whitespaces.split(tickStr);
        if (tickArr.length <= CentralProcessor.TickType.IDLE.getIndex()) {
            return ticks;
        }
        for (int i = 0; i < CentralProcessor.TickType.values().length; ++i) {
            ticks[i] = ParseUtil.parseLongOrDefault(tickArr[i + 1], 0L);
        }
        return ticks;
    }

    public static File[] getPidFiles() {
        File procdir = new File(ProcUtil.getProcPath());
        File[] pids = procdir.listFiles(f -> DIGITS.matcher(f.getName()).matches());
        return pids != null ? pids : new File[]{};
    }
}

