/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.software.os.unix.freebsd;

import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.Native;
import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.ptr.PointerByReference;
import com.gamedash.daemon.wrapper.dependencies.oshi.jna.platform.unix.CLibrary;
import com.gamedash.daemon.wrapper.dependencies.oshi.jna.platform.unix.freebsd.FreeBsdLibc;
import com.gamedash.daemon.wrapper.dependencies.oshi.software.common.AbstractNetworkParams;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ExecutingCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeBsdNetworkParams
extends AbstractNetworkParams {
    private static final Logger LOG = LoggerFactory.getLogger(FreeBsdNetworkParams.class);
    private static final FreeBsdLibc LIBC = FreeBsdLibc.INSTANCE;

    @Override
    public String getDomainName() {
        PointerByReference ptr;
        CLibrary.Addrinfo hint = new CLibrary.Addrinfo();
        hint.ai_flags = 2;
        String hostname = this.getHostName();
        int res = LIBC.getaddrinfo(hostname, null, hint, ptr = new PointerByReference());
        if (res > 0) {
            if (LOG.isErrorEnabled()) {
                LOG.warn("Failed getaddrinfo(): {}", (Object)LIBC.gai_strerror(res));
            }
            return "";
        }
        CLibrary.Addrinfo info = new CLibrary.Addrinfo(ptr.getValue());
        String canonname = info.ai_canonname.trim();
        LIBC.freeaddrinfo(ptr.getValue());
        return canonname;
    }

    @Override
    public String getHostName() {
        byte[] hostnameBuffer = new byte[256];
        if (0 != LIBC.gethostname(hostnameBuffer, hostnameBuffer.length)) {
            return super.getHostName();
        }
        return Native.toString(hostnameBuffer);
    }

    @Override
    public String getIpv4DefaultGateway() {
        return FreeBsdNetworkParams.searchGateway(ExecutingCommand.runNative("route -4 get default"));
    }

    @Override
    public String getIpv6DefaultGateway() {
        return FreeBsdNetworkParams.searchGateway(ExecutingCommand.runNative("route -6 get default"));
    }
}

