/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.software.os.mac;

import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.Native;
import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.ptr.PointerByReference;
import com.gamedash.daemon.wrapper.dependencies.oshi.jna.platform.mac.SystemB;
import com.gamedash.daemon.wrapper.dependencies.oshi.jna.platform.unix.CLibrary;
import com.gamedash.daemon.wrapper.dependencies.oshi.software.common.AbstractNetworkParams;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ExecutingCommand;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ParseUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacNetworkParams
extends AbstractNetworkParams {
    private static final Logger LOG = LoggerFactory.getLogger(MacNetworkParams.class);
    private static final SystemB SYS = SystemB.INSTANCE;
    private static final String IPV6_ROUTE_HEADER = "Internet6:";
    private static final String DEFAULT_GATEWAY = "default";

    @Override
    public String getDomainName() {
        CLibrary.Addrinfo hint = new CLibrary.Addrinfo();
        hint.ai_flags = 2;
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unknown host exception when getting address of local host: {}", e);
            return "";
        }
        PointerByReference ptr = new PointerByReference();
        int res = SYS.getaddrinfo(hostname, null, hint, ptr);
        if (res > 0) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Failed getaddrinfo(): {}", (Object)SYS.gai_strerror(res));
            }
            return "";
        }
        CLibrary.Addrinfo info = new CLibrary.Addrinfo(ptr.getValue());
        String canonname = info.ai_canonname.trim();
        SYS.freeaddrinfo(ptr.getValue());
        return canonname;
    }

    @Override
    public String getHostName() {
        byte[] hostnameBuffer = new byte[256];
        if (0 != SYS.gethostname(hostnameBuffer, hostnameBuffer.length)) {
            return super.getHostName();
        }
        return Native.toString(hostnameBuffer);
    }

    @Override
    public String getIpv4DefaultGateway() {
        return MacNetworkParams.searchGateway(ExecutingCommand.runNative("route -n get default"));
    }

    @Override
    public String getIpv6DefaultGateway() {
        List<String> lines = ExecutingCommand.runNative("netstat -nr");
        boolean v6Table = false;
        for (String line : lines) {
            if (v6Table && line.startsWith(DEFAULT_GATEWAY)) {
                String[] fields = ParseUtil.whitespaces.split(line);
                if (fields.length <= 2 || !fields[2].contains("G")) continue;
                return fields[1].split("%")[0];
            }
            if (!line.startsWith(IPV6_ROUTE_HEADER)) continue;
            v6Table = true;
        }
        return "";
    }
}

