/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.windows;

import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.platform.win32.Advapi32Util;
import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.platform.win32.Win32Exception;
import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.platform.win32.WinReg;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.common.AbstractSoundCard;
import java.util.ArrayList;
import java.util.List;

public class WindowsSoundCard
extends AbstractSoundCard {
    private static final String REGISTRY_SOUNDCARDS = "SYSTEM\\CurrentControlSet\\Control\\Class\\{4d36e96c-e325-11ce-bfc1-08002be10318}\\";

    public WindowsSoundCard(String kernelVersion, String name, String codec) {
        super(kernelVersion, name, codec);
    }

    public static List<WindowsSoundCard> getSoundCards() {
        String[] keys;
        ArrayList<WindowsSoundCard> soundCards = new ArrayList<WindowsSoundCard>();
        for (String key : keys = Advapi32Util.registryGetKeys(WinReg.HKEY_LOCAL_MACHINE, REGISTRY_SOUNDCARDS)) {
            String fullKey = REGISTRY_SOUNDCARDS + key;
            try {
                if (!Advapi32Util.registryValueExists(WinReg.HKEY_LOCAL_MACHINE, fullKey, "Driver")) continue;
                soundCards.add(new WindowsSoundCard(Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, fullKey, "Driver") + " " + Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, fullKey, "DriverVersion"), Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, fullKey, "ProviderName") + " " + Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, fullKey, "DriverDesc"), Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, fullKey, "DriverDesc")));
            }
            catch (Win32Exception e) {
                if (e.getErrorCode() == 5) continue;
                throw e;
            }
        }
        return soundCards;
    }
}

