/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.windows;

import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.perfmon.ThermalZoneInformation;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.wmi.OhmHardware;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.wmi.OhmSensor;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.wmi.Win32Fan;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.wmi.Win32Processor;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.common.AbstractSensors;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.platform.windows.WmiUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsSensors
extends AbstractSensors {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsSensors.class);

    @Override
    public double queryCpuTemperature() {
        double tempC = this.getTempFromOHM();
        if (tempC > 0.0) {
            return tempC;
        }
        tempC = this.getTempFromPerfCounters();
        return tempC;
    }

    private double getTempFromOHM() {
        WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty> ohmHardware = new OhmHardware().queryHwIdentifier("Hardware", "CPU");
        if (ohmHardware.getResultCount() > 0) {
            WbemcliUtil.WmiResult<OhmSensor.ValueProperty> ohmSensors;
            LOG.debug("Found Temperature data in Open Hardware Monitor");
            String cpuIdentifier = WmiUtil.getString(ohmHardware, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
            if (cpuIdentifier.length() > 0 && (ohmSensors = new OhmSensor().querySensorValue(cpuIdentifier, "Temperature")).getResultCount() > 0) {
                double sum = 0.0;
                for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                    sum += (double)WmiUtil.getFloat(ohmSensors, OhmSensor.ValueProperty.VALUE, i);
                }
                return sum / (double)ohmSensors.getResultCount();
            }
        }
        return 0.0;
    }

    private double getTempFromPerfCounters() {
        double tempC = 0.0;
        long tempK = 0L;
        Map<ThermalZoneInformation.ThermalZoneProperty, List<Long>> valueListMap = new ThermalZoneInformation().queryThermalZoneTemps();
        List<Long> valueList = valueListMap.get(ThermalZoneInformation.ThermalZoneProperty.TEMPERATURE);
        if (valueList != null && !valueList.isEmpty()) {
            LOG.debug("Found Temperature data in PDH or WMI Counter");
            tempK = valueList.get(0);
        }
        if (tempK > 2732L) {
            tempC = (double)tempK / 10.0 - 273.15;
        } else if (tempK > 274L) {
            tempC = (double)tempK - 273.0;
        }
        return tempC < 0.0 ? 0.0 : tempC;
    }

    @Override
    public int[] queryFanSpeeds() {
        int[] fanSpeeds = this.getFansFromOHM();
        if (fanSpeeds.length > 0) {
            return fanSpeeds;
        }
        fanSpeeds = this.getFansFromWMI();
        if (fanSpeeds.length > 0) {
            return fanSpeeds;
        }
        return new int[0];
    }

    private int[] getFansFromOHM() {
        WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty> ohmHardware = new OhmHardware().queryHwIdentifier("Hardware", "CPU");
        if (ohmHardware.getResultCount() > 0) {
            WbemcliUtil.WmiResult<OhmSensor.ValueProperty> ohmSensors;
            LOG.debug("Found Fan data in Open Hardware Monitor");
            String cpuIdentifier = WmiUtil.getString(ohmHardware, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
            if (cpuIdentifier.length() > 0 && (ohmSensors = new OhmSensor().querySensorValue(cpuIdentifier, "Fan")).getResultCount() > 0) {
                int[] fanSpeeds = new int[ohmSensors.getResultCount()];
                for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                    fanSpeeds[i] = (int)WmiUtil.getFloat(ohmSensors, OhmSensor.ValueProperty.VALUE, i);
                }
                return fanSpeeds;
            }
        }
        return new int[0];
    }

    private int[] getFansFromWMI() {
        WbemcliUtil.WmiResult<Win32Fan.SpeedProperty> fan = new Win32Fan().querySpeed();
        if (fan.getResultCount() > 1) {
            LOG.debug("Found Fan data in WMI");
            int[] fanSpeeds = new int[fan.getResultCount()];
            for (int i = 0; i < fan.getResultCount(); ++i) {
                fanSpeeds[i] = (int)WmiUtil.getUint64(fan, Win32Fan.SpeedProperty.DESIREDSPEED, i);
            }
            return fanSpeeds;
        }
        return new int[0];
    }

    @Override
    public double queryCpuVoltage() {
        double volts = this.getVoltsFromOHM();
        if (volts > 0.0) {
            return volts;
        }
        volts = this.getVoltsFromWMI();
        return volts;
    }

    private double getVoltsFromOHM() {
        WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty> ohmHardware = new OhmHardware().queryHwIdentifier("Sensor", "Voltage");
        if (ohmHardware.getResultCount() > 0) {
            WbemcliUtil.WmiResult<OhmSensor.ValueProperty> ohmSensors;
            LOG.debug("Found Voltage data in Open Hardware Monitor");
            String cpuIdentifier = null;
            for (int i = 0; i < ohmHardware.getResultCount(); ++i) {
                String id = WmiUtil.getString(ohmHardware, OhmHardware.IdentifierProperty.IDENTIFIER, i);
                if (!id.toLowerCase().contains("cpu")) continue;
                cpuIdentifier = id;
                break;
            }
            if (cpuIdentifier == null) {
                cpuIdentifier = WmiUtil.getString(ohmHardware, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
            }
            if ((ohmSensors = new OhmSensor().querySensorValue(cpuIdentifier, "Voltage")).getResultCount() > 0) {
                return WmiUtil.getFloat(ohmSensors, OhmSensor.ValueProperty.VALUE, 0);
            }
        }
        return 0.0;
    }

    private double getVoltsFromWMI() {
        WbemcliUtil.WmiResult<Win32Processor.VoltProperty> voltage = new Win32Processor().queryVoltage();
        if (voltage.getResultCount() > 1) {
            LOG.debug("Found Voltage data in WMI");
            int decivolts = WmiUtil.getUint16(voltage, Win32Processor.VoltProperty.CURRENTVOLTAGE, 0);
            if (decivolts > 0) {
                if ((decivolts & 0x80) == 0) {
                    decivolts = WmiUtil.getUint32(voltage, Win32Processor.VoltProperty.VOLTAGECAPS, 0);
                    if ((decivolts & 1) > 0) {
                        return 5.0;
                    }
                    if ((decivolts & 2) > 0) {
                        return 3.3;
                    }
                    if ((decivolts & 4) > 0) {
                        return 2.9;
                    }
                } else {
                    return (double)(decivolts & 0x7F) / 10.0;
                }
            }
        }
        return 0.0;
    }
}

