/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.windows;

import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.platform.win32.IPHlpAPI;
import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.platform.win32.VersionHelpers;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.NetworkIF;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.common.AbstractNetworks;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ParseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsNetworks
extends AbstractNetworks {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsNetworks.class);
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();

    public static boolean updateNetworkStats(NetworkIF netIF) {
        if (IS_VISTA_OR_GREATER) {
            IPHlpAPI.MIB_IF_ROW2 ifRow = new IPHlpAPI.MIB_IF_ROW2();
            ifRow.InterfaceIndex = netIF.queryNetworkInterface().getIndex();
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry2(ifRow)) {
                LOG.error("Failed to retrieve data for interface {}, {}", (Object)netIF.queryNetworkInterface().getIndex(), (Object)netIF.getName());
                return false;
            }
            netIF.setBytesSent(ifRow.OutOctets);
            netIF.setBytesRecv(ifRow.InOctets);
            netIF.setPacketsSent(ifRow.OutUcastPkts);
            netIF.setPacketsRecv(ifRow.InUcastPkts);
            netIF.setOutErrors(ifRow.OutErrors);
            netIF.setInErrors(ifRow.InErrors);
            netIF.setCollisions(ifRow.OutDiscards);
            netIF.setInDrops(ifRow.InDiscards);
            netIF.setSpeed(ifRow.ReceiveLinkSpeed);
        } else {
            IPHlpAPI.MIB_IFROW ifRow = new IPHlpAPI.MIB_IFROW();
            ifRow.dwIndex = netIF.queryNetworkInterface().getIndex();
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry(ifRow)) {
                LOG.error("Failed to retrieve data for interface {}, {}", (Object)netIF.queryNetworkInterface().getIndex(), (Object)netIF.getName());
                return false;
            }
            netIF.setBytesSent(ParseUtil.unsignedIntToLong(ifRow.dwOutOctets));
            netIF.setBytesRecv(ParseUtil.unsignedIntToLong(ifRow.dwInOctets));
            netIF.setPacketsSent(ParseUtil.unsignedIntToLong(ifRow.dwOutUcastPkts));
            netIF.setPacketsRecv(ParseUtil.unsignedIntToLong(ifRow.dwInUcastPkts));
            netIF.setOutErrors(ParseUtil.unsignedIntToLong(ifRow.dwOutErrors));
            netIF.setInErrors(ParseUtil.unsignedIntToLong(ifRow.dwInErrors));
            netIF.setCollisions(ParseUtil.unsignedIntToLong(ifRow.dwOutDiscards));
            netIF.setInDrops(ParseUtil.unsignedIntToLong(ifRow.dwInDiscards));
            netIF.setSpeed(ParseUtil.unsignedIntToLong(ifRow.dwSpeed));
        }
        netIF.setTimeStamp(System.currentTimeMillis());
        return true;
    }
}

