/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.windows;

import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.platform.win32.Kernel32;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.perfmon.PhysicalDisk;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.wmi.Win32DiskDrive;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.wmi.Win32DiskDriveToDiskPartition;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.wmi.Win32DiskPartition;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.wmi.Win32LogicalDiskToPartition;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.Disks;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.HWDiskStore;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.HWPartition;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ParseUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.platform.windows.WmiUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.tuples.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsDisks
implements Disks {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsDisks.class);
    private static final String PHYSICALDRIVE_PREFIX = "\\\\.\\PHYSICALDRIVE";
    private static final Pattern DEVICE_ID = Pattern.compile(".*\\.DeviceID=\"(.*)\"");
    private static final int BUFSIZE = 255;

    public static boolean updateDiskStats(HWDiskStore diskStore) {
        String index = null;
        HWPartition[] partitions = diskStore.getPartitions();
        if (partitions.length > 0) {
            index = Integer.toString(partitions[0].getMajor());
        } else if (diskStore.getName().startsWith(PHYSICALDRIVE_PREFIX)) {
            index = diskStore.getName().substring(PHYSICALDRIVE_PREFIX.length(), diskStore.getName().length());
        } else {
            LOG.warn("Couldn't match index for {}", (Object)diskStore.getName());
            return false;
        }
        DiskStats stats = WindowsDisks.queryReadWriteStats(index);
        if (stats.readMap.containsKey(index)) {
            diskStore.setReads(stats.readMap.getOrDefault(index, 0L));
            diskStore.setReadBytes(stats.readByteMap.getOrDefault(index, 0L));
            diskStore.setWrites(stats.writeMap.getOrDefault(index, 0L));
            diskStore.setWriteBytes(stats.writeByteMap.getOrDefault(index, 0L));
            diskStore.setCurrentQueueLength(stats.queueLengthMap.getOrDefault(index, 0L));
            diskStore.setTransferTime(stats.timeStamp - stats.idleTimeMap.getOrDefault(index, stats.timeStamp));
            diskStore.setTimeStamp(stats.timeStamp);
            return true;
        }
        return false;
    }

    @Override
    public HWDiskStore[] getDisks() {
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        DiskStats stats = WindowsDisks.queryReadWriteStats(null);
        PartitionMaps maps = this.queryPartitionMaps();
        WbemcliUtil.WmiResult<Win32DiskDrive.DiskDriveProperty> vals = new Win32DiskDrive().queryDiskDrive();
        for (int i = 0; i < vals.getResultCount(); ++i) {
            HWDiskStore ds = new HWDiskStore();
            ds.setName(WmiUtil.getString(vals, Win32DiskDrive.DiskDriveProperty.NAME, i));
            ds.setModel(String.format("%s %s", WmiUtil.getString(vals, Win32DiskDrive.DiskDriveProperty.MODEL, i), WmiUtil.getString(vals, Win32DiskDrive.DiskDriveProperty.MANUFACTURER, i)).trim());
            ds.setSerial(ParseUtil.hexStringToString(WmiUtil.getString(vals, Win32DiskDrive.DiskDriveProperty.SERIALNUMBER, i)));
            String index = Integer.toString(WmiUtil.getUint32(vals, Win32DiskDrive.DiskDriveProperty.INDEX, i));
            ds.setReads(stats.readMap.getOrDefault(index, 0L));
            ds.setReadBytes(stats.readByteMap.getOrDefault(index, 0L));
            ds.setWrites(stats.writeMap.getOrDefault(index, 0L));
            ds.setWriteBytes(stats.writeByteMap.getOrDefault(index, 0L));
            ds.setCurrentQueueLength(stats.queueLengthMap.getOrDefault(index, 0L));
            ds.setTransferTime(stats.timeStamp - stats.idleTimeMap.getOrDefault(index, stats.timeStamp));
            ds.setTimeStamp(stats.timeStamp);
            ds.setSize(WmiUtil.getUint64(vals, Win32DiskDrive.DiskDriveProperty.SIZE, i));
            ArrayList<HWPartition> partitions = new ArrayList<HWPartition>();
            List partList = (List)maps.driveToPartitionMap.get(ds.getName());
            if (partList != null && !partList.isEmpty()) {
                for (String part : partList) {
                    if (!maps.partitionMap.containsKey(part)) continue;
                    partitions.add((HWPartition)maps.partitionMap.get(part));
                }
            }
            ds.setPartitions(partitions.toArray(new HWPartition[0]));
            result.add(ds);
        }
        return result.toArray(new HWDiskStore[0]);
    }

    private static DiskStats queryReadWriteStats(String index) {
        DiskStats stats = new DiskStats();
        Pair<List<String>, Map<PhysicalDisk.PhysicalDiskProperty, List<Long>>> instanceValuePair = new PhysicalDisk().queryDiskCounters();
        List<String> instances = instanceValuePair.getA();
        Map<PhysicalDisk.PhysicalDiskProperty, List<Long>> valueMap = instanceValuePair.getB();
        stats.timeStamp = System.currentTimeMillis();
        List<Long> readList = valueMap.get(PhysicalDisk.PhysicalDiskProperty.DISKREADSPERSEC);
        List<Long> readByteList = valueMap.get(PhysicalDisk.PhysicalDiskProperty.DISKREADBYTESPERSEC);
        List<Long> writeList = valueMap.get(PhysicalDisk.PhysicalDiskProperty.DISKWRITESPERSEC);
        List<Long> writeByteList = valueMap.get(PhysicalDisk.PhysicalDiskProperty.DISKWRITEBYTESPERSEC);
        List<Long> queueLengthList = valueMap.get(PhysicalDisk.PhysicalDiskProperty.CURRENTDISKQUEUELENGTH);
        List<Long> idleTimeList = valueMap.get(PhysicalDisk.PhysicalDiskProperty.PERCENTIDLETIME);
        if (instances.isEmpty() || readList == null || readByteList == null || writeList == null || writeByteList == null || queueLengthList == null || idleTimeList == null) {
            return stats;
        }
        for (int i = 0; i < instances.size(); ++i) {
            String name = WindowsDisks.getIndexFromName(instances.get(i));
            if (index != null && !index.equals(name)) continue;
            stats.readMap.put(name, readList.get(i));
            stats.readByteMap.put(name, readByteList.get(i));
            stats.writeMap.put(name, writeList.get(i));
            stats.writeByteMap.put(name, writeByteList.get(i));
            stats.queueLengthMap.put(name, queueLengthList.get(i));
            stats.idleTimeMap.put(name, idleTimeList.get(i) / 10000L);
        }
        return stats;
    }

    private PartitionMaps queryPartitionMaps() {
        Matcher mDep;
        Matcher mAnt;
        PartitionMaps maps = new PartitionMaps();
        WbemcliUtil.WmiResult<Win32DiskDriveToDiskPartition.DriveToPartitionProperty> drivePartitionMap = new Win32DiskDriveToDiskPartition().queryDriveToPartition();
        for (int i = 0; i < drivePartitionMap.getResultCount(); ++i) {
            mAnt = DEVICE_ID.matcher(WmiUtil.getRefString(drivePartitionMap, Win32DiskDriveToDiskPartition.DriveToPartitionProperty.ANTECEDENT, i));
            mDep = DEVICE_ID.matcher(WmiUtil.getRefString(drivePartitionMap, Win32DiskDriveToDiskPartition.DriveToPartitionProperty.DEPENDENT, i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            maps.driveToPartitionMap.computeIfAbsent(mAnt.group(1).replaceAll("\\\\\\\\", "\\\\"), x -> new ArrayList()).add(mDep.group(1));
        }
        WbemcliUtil.WmiResult<Win32LogicalDiskToPartition.DiskToPartitionProperty> diskPartitionMap = new Win32LogicalDiskToPartition().queryDiskToPartition();
        for (int i = 0; i < diskPartitionMap.getResultCount(); ++i) {
            mAnt = DEVICE_ID.matcher(WmiUtil.getRefString(diskPartitionMap, Win32LogicalDiskToPartition.DiskToPartitionProperty.ANTECEDENT, i));
            mDep = DEVICE_ID.matcher(WmiUtil.getRefString(diskPartitionMap, Win32LogicalDiskToPartition.DiskToPartitionProperty.DEPENDENT, i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            maps.partitionToLogicalDriveMap.put(mAnt.group(1), mDep.group(1) + "\\");
        }
        WbemcliUtil.WmiResult<Win32DiskPartition.DiskPartitionProperty> hwPartitionQueryMap = new Win32DiskPartition().queryPartition();
        for (int i = 0; i < hwPartitionQueryMap.getResultCount(); ++i) {
            String deviceID = WmiUtil.getString(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.DEVICEID, i);
            String logicalDrive = maps.partitionToLogicalDriveMap.getOrDefault(deviceID, "");
            String uuid = "";
            if (!logicalDrive.isEmpty()) {
                char[] volumeChr = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(logicalDrive, volumeChr, 255);
                uuid = ParseUtil.parseUuidOrDefault(new String(volumeChr).trim(), "");
            }
            maps.partitionMap.put(deviceID, new HWPartition(WmiUtil.getString(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.NAME, i), WmiUtil.getString(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.TYPE, i), WmiUtil.getString(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.DESCRIPTION, i), uuid, WmiUtil.getUint64(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.SIZE, i), WmiUtil.getUint32(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.DISKINDEX, i), WmiUtil.getUint32(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.INDEX, i), logicalDrive));
        }
        return maps;
    }

    private static String getIndexFromName(String s) {
        if (s.isEmpty()) {
            return s;
        }
        return s.split("\\s")[0];
    }

    private static final class DiskStats {
        private final Map<String, Long> readMap = new HashMap<String, Long>();
        private final Map<String, Long> readByteMap = new HashMap<String, Long>();
        private final Map<String, Long> writeMap = new HashMap<String, Long>();
        private final Map<String, Long> writeByteMap = new HashMap<String, Long>();
        private final Map<String, Long> queueLengthMap = new HashMap<String, Long>();
        private final Map<String, Long> idleTimeMap = new HashMap<String, Long>();
        private long timeStamp;

        private DiskStats() {
        }
    }

    private static final class PartitionMaps {
        private final Map<String, List<String>> driveToPartitionMap = new HashMap<String, List<String>>();
        private final Map<String, String> partitionToLogicalDriveMap = new HashMap<String, String>();
        private final Map<String, HWPartition> partitionMap = new HashMap<String, HWPartition>();

        private PartitionMaps() {
        }
    }
}

