/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.windows;

import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.wmi.Win32Bios;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.wmi.Win32ComputerSystem;
import com.gamedash.daemon.wrapper.dependencies.oshi.driver.wmi.Win32ComputerSystemProduct;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.Baseboard;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.Firmware;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.common.AbstractComputerSystem;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.windows.WindowsBaseboard;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.windows.WindowsFirmware;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.Memoizer;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.Util;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.platform.windows.WmiUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.tuples.Pair;
import java.util.function.Supplier;

final class WindowsComputerSystem
extends AbstractComputerSystem {
    private final Supplier<Pair<String, String>> manufacturerModel = Memoizer.memoize(this::queryManufacturerModel);
    private final Supplier<String> serialNumber = Memoizer.memoize(this::querySystemSerialNumber);

    WindowsComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        return this.manufacturerModel.get().getA();
    }

    @Override
    public String getModel() {
        return this.manufacturerModel.get().getB();
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber.get();
    }

    @Override
    public Firmware createFirmware() {
        return new WindowsFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new WindowsBaseboard();
    }

    private Pair<String, String> queryManufacturerModel() {
        String manufacturer = null;
        String model = null;
        WbemcliUtil.WmiResult<Win32ComputerSystem.ComputerSystemProperty> win32ComputerSystem = new Win32ComputerSystem().queryComputerSystem();
        if (win32ComputerSystem.getResultCount() > 0) {
            manufacturer = WmiUtil.getString(win32ComputerSystem, Win32ComputerSystem.ComputerSystemProperty.MANUFACTURER, 0);
            model = WmiUtil.getString(win32ComputerSystem, Win32ComputerSystem.ComputerSystemProperty.MODEL, 0);
        }
        return new Pair<String, String>(Util.isBlank(manufacturer) ? "unknown" : manufacturer, Util.isBlank(model) ? "unknown" : model);
    }

    private String querySystemSerialNumber() {
        String result = this.querySerialFromBios();
        if (!(result == null && (result = this.querySerialFromCsProduct()) == null || Util.isBlank(result))) {
            return result;
        }
        return "unknown";
    }

    private String querySerialFromBios() {
        WbemcliUtil.WmiResult<Win32Bios.BiosSerialProperty> serialNum = new Win32Bios().querySerialNumber();
        if (serialNum.getResultCount() > 0) {
            return WmiUtil.getString(serialNum, Win32Bios.BiosSerialProperty.SERIALNUMBER, 0);
        }
        return null;
    }

    private String querySerialFromCsProduct() {
        WbemcliUtil.WmiResult<Win32ComputerSystemProduct.ComputerSystemProductProperty> identifyingNumber = new Win32ComputerSystemProduct().queryIdentifyingNumber();
        if (identifyingNumber.getResultCount() > 0) {
            return WmiUtil.getString(identifyingNumber, Win32ComputerSystemProduct.ComputerSystemProductProperty.IDENTIFYINGNUMBER, 0);
        }
        return null;
    }
}

