/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.unix.solaris;

import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.platform.unix.solaris.LibKstat;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.VirtualMemory;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.common.AbstractGlobalMemory;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.unix.solaris.SolarisVirtualMemory;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ExecutingCommand;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.Memoizer;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ParseUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.platform.unix.solaris.KstatUtil;
import java.util.function.Supplier;

public class SolarisGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<SystemPages> systemPages = Memoizer.memoize(this::readSystemPages, Memoizer.defaultExpiration());
    private final Supplier<Long> pageSize = Memoizer.memoize(this::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    @Override
    public long getAvailable() {
        return this.systemPages.get().available;
    }

    @Override
    public long getTotal() {
        return this.systemPages.get().total;
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private long queryPageSize() {
        return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("pagesize"), 4096L);
    }

    private VirtualMemory createVirtualMemory() {
        return new SolarisVirtualMemory();
    }

    private SystemPages readSystemPages() {
        long memAvailable = 0L;
        long memTotal = 0L;
        try (KstatUtil.KstatChain kc = KstatUtil.openChain();){
            LibKstat.Kstat ksp = kc.lookup(null, -1, "system_pages");
            if (ksp != null && kc.read(ksp)) {
                memAvailable = KstatUtil.dataLookupLong(ksp, "availrmem") * this.getPageSize();
                memTotal = KstatUtil.dataLookupLong(ksp, "physmem") * this.getPageSize();
            }
        }
        return new SystemPages(memTotal, memAvailable);
    }

    private static final class SystemPages {
        private final long total;
        private final long available;

        private SystemPages(long total, long available) {
            this.total = total;
            this.available = available;
        }
    }
}

