/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.unix.solaris;

import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.Display;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.common.AbstractDisplay;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ExecutingCommand;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ParseUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolarisDisplay
extends AbstractDisplay {
    private static final Logger LOG = LoggerFactory.getLogger(SolarisDisplay.class);

    public SolarisDisplay(byte[] edid) {
        super(edid);
        LOG.debug("Initialized SolarisDisplay");
    }

    public static Display[] getDisplays() {
        List<String> xrandr = ExecutingCommand.runNative("xrandr --verbose");
        if (xrandr.isEmpty()) {
            return new Display[0];
        }
        ArrayList<SolarisDisplay> displays = new ArrayList<SolarisDisplay>();
        StringBuilder sb = null;
        for (String s : xrandr) {
            if (s.contains("EDID")) {
                sb = new StringBuilder();
                continue;
            }
            if (sb == null) continue;
            sb.append(s.trim());
            if (sb.length() < 256) continue;
            String edidStr = sb.toString();
            LOG.debug("Parsed EDID: {}", (Object)edidStr);
            byte[] edid = ParseUtil.hexStringToByteArray(edidStr);
            if (edid.length >= 128) {
                displays.add(new SolarisDisplay(edid));
            }
            sb = null;
        }
        return displays.toArray(new Display[0]);
    }
}

