/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.unix.freebsd;

import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.Disks;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.HWDiskStore;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.HWPartition;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ExecutingCommand;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ParseUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.platform.unix.freebsd.BsdSysctlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FreeBsdDisks
implements Disks {
    private static final Pattern MOUNT_PATTERN = Pattern.compile("/dev/(\\S+p\\d+) on (\\S+) .*");

    public static boolean updateDiskStats(HWDiskStore diskStore) {
        List<String> output = ExecutingCommand.runNative("iostat -Ix " + diskStore.getName());
        long timeStamp = System.currentTimeMillis();
        boolean diskFound = false;
        for (String line : output) {
            String[] split = ParseUtil.whitespaces.split(line);
            if (split.length < 7 || !split[0].equals(diskStore.getName())) continue;
            diskFound = true;
            diskStore.setReads((long)ParseUtil.parseDoubleOrDefault(split[1], 0.0));
            diskStore.setWrites((long)ParseUtil.parseDoubleOrDefault(split[2], 0.0));
            diskStore.setReadBytes((long)(ParseUtil.parseDoubleOrDefault(split[3], 0.0) * 1024.0));
            diskStore.setWriteBytes((long)(ParseUtil.parseDoubleOrDefault(split[4], 0.0) * 1024.0));
            diskStore.setCurrentQueueLength(ParseUtil.parseLongOrDefault(split[5], 0L));
            diskStore.setTransferTime((long)(ParseUtil.parseDoubleOrDefault(split[6], 0.0) * 1000.0));
            diskStore.setTimeStamp(timeStamp);
        }
        return diskFound;
    }

    @Override
    public HWDiskStore[] getDisks() {
        HashMap<String, String> mountMap = new HashMap<String, String>();
        for (String mnt : ExecutingCommand.runNative("mount")) {
            Matcher m = MOUNT_PATTERN.matcher(mnt);
            if (!m.matches()) continue;
            mountMap.put(m.group(1), m.group(2));
        }
        HashMap<Object, HWDiskStore> diskMap = new HashMap<Object, HWDiskStore>();
        List<String> devices = Arrays.asList(ParseUtil.whitespaces.split(BsdSysctlUtil.sysctl("kern.disks", "")));
        ArrayList<HWPartition> partList = new ArrayList<HWPartition>();
        List<String> disks = ExecutingCommand.runNative("iostat -Ix");
        long timeStamp = System.currentTimeMillis();
        for (String line : disks) {
            String[] split = ParseUtil.whitespaces.split(line);
            if (split.length < 7 || !devices.contains(split[0])) continue;
            HWDiskStore hWDiskStore = new HWDiskStore();
            hWDiskStore.setName((String)split[0]);
            hWDiskStore.setReads((long)ParseUtil.parseDoubleOrDefault((String)split[1], 0.0));
            hWDiskStore.setWrites((long)ParseUtil.parseDoubleOrDefault((String)split[2], 0.0));
            hWDiskStore.setReadBytes((long)(ParseUtil.parseDoubleOrDefault((String)split[3], 0.0) * 1024.0));
            hWDiskStore.setWriteBytes((long)(ParseUtil.parseDoubleOrDefault((String)split[4], 0.0) * 1024.0));
            hWDiskStore.setCurrentQueueLength(ParseUtil.parseLongOrDefault((String)split[5], 0L));
            hWDiskStore.setTransferTime((long)(ParseUtil.parseDoubleOrDefault((String)split[6], 0.0) * 1000.0));
            hWDiskStore.setTimeStamp(timeStamp);
            diskMap.put(split[0], hWDiskStore);
        }
        List<String> geom = ExecutingCommand.runNative("geom disk list");
        HWDiskStore store = null;
        for (String string : geom) {
            String[] split;
            if (string.startsWith("Geom name:")) {
                String device;
                if (store != null) {
                    this.setPartitions(store, partList);
                }
                if (devices.contains(device = string.substring(string.lastIndexOf(32) + 1)) && (store = (HWDiskStore)diskMap.get(device)) == null) {
                    store = new HWDiskStore();
                    store.setName(device);
                }
            }
            if (store == null) continue;
            String string2 = string.trim();
            if (string2.startsWith("Mediasize:") && (split = ParseUtil.whitespaces.split(string2)).length > 1) {
                store.setSize(ParseUtil.parseLongOrDefault(split[1], 0L));
            }
            if (string2.startsWith("descr:")) {
                store.setModel(string2.replace("descr:", "").trim());
            }
            if (!string2.startsWith("ident:")) continue;
            store.setSerial(string2.replace("ident:", "").replace("(null)", "").trim());
        }
        geom = ExecutingCommand.runNative("geom part list");
        store = null;
        HWPartition partition = null;
        for (String line : geom) {
            String[] split;
            String device;
            if ((line = line.trim()).startsWith("Geom name:") && devices.contains(device = line.substring(line.lastIndexOf(32) + 1)) && (store = (HWDiskStore)diskMap.get(device)) == null) {
                store = new HWDiskStore();
                store.setName(device);
            }
            if (store == null) continue;
            if (line.contains("Name:")) {
                String part;
                if (partition != null) {
                    partList.add(partition);
                    partition = null;
                }
                if ((part = line.substring(line.lastIndexOf(32) + 1)).startsWith(store.getName())) {
                    partition = new HWPartition();
                    partition.setIdentification(part);
                    partition.setName(part);
                    partition.setMountPoint(mountMap.getOrDefault(part, ""));
                }
            }
            if (partition == null || (split = ParseUtil.whitespaces.split(line)).length < 2) continue;
            if (line.startsWith("Mediasize:")) {
                partition.setSize(ParseUtil.parseLongOrDefault(split[1], 0L));
                continue;
            }
            if (line.startsWith("rawuuid:")) {
                partition.setUuid(split[1]);
                continue;
            }
            if (!line.startsWith("type:")) continue;
            partition.setType(split[1]);
        }
        if (store != null) {
            this.setPartitions(store, partList);
        }
        ArrayList arrayList = new ArrayList(diskMap.keySet().size());
        arrayList.addAll(diskMap.values());
        Collections.sort(arrayList);
        return arrayList.toArray(new HWDiskStore[0]);
    }

    private void setPartitions(HWDiskStore store, List<HWPartition> partList) {
        HWPartition[] partitions = new HWPartition[partList.size()];
        int index = 0;
        Collections.sort(partList);
        for (HWPartition partition : partList) {
            partition.setMinor(ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("stat -f %i /dev/" + partition.getName()), 0));
            partitions[index++] = partition;
        }
        partList.clear();
        store.setPartitions(partitions);
    }
}

