/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.mac;

import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.common.AbstractSoundCard;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.FileUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ParseUtil;
import java.util.ArrayList;
import java.util.List;

public class MacSoundCard
extends AbstractSoundCard {
    private static final String APPLE = "Apple Inc.";

    public MacSoundCard(String kernelVersion, String name, String codec) {
        super(kernelVersion, name, codec);
    }

    public static List<MacSoundCard> getSoundCards() {
        ArrayList<MacSoundCard> soundCards = new ArrayList<MacSoundCard>();
        String manufacturer = APPLE;
        String kernelVersion = "AppleHDAController";
        String codec = "AppleHDACodec";
        boolean version = false;
        String versionMarker = "<key>com.apple.driver.AppleHDAController</key>";
        for (String checkLine : FileUtil.readFile("/System/Library/Extensions/AppleHDA.kext/Contents/Info.plist")) {
            if (checkLine.contains(versionMarker)) {
                version = true;
                continue;
            }
            if (!version) continue;
            kernelVersion = "AppleHDAController " + ParseUtil.getTextBetweenStrings(checkLine, "<string>", "</string>");
            version = false;
        }
        soundCards.add(new MacSoundCard(kernelVersion, manufacturer, codec));
        return soundCards;
    }
}

