/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.mac;

import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.Memory;
import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.Pointer;
import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.platform.mac.SystemB;
import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.ptr.IntByReference;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.NetworkIF;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.common.AbstractNetworks;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacNetworks
extends AbstractNetworks {
    private static final Logger LOG = LoggerFactory.getLogger(MacNetworks.class);
    private static final int CTL_NET = 4;
    private static final int PF_ROUTE = 17;
    private static final int NET_RT_IFLIST2 = 6;
    private static final int RTM_IFINFO2 = 18;

    @Override
    public NetworkIF[] getNetworks() {
        ArrayList<NetworkIF> result = new ArrayList<NetworkIF>();
        Map<Integer, IFdata> ifDataMap = MacNetworks.queryIFdata(-1);
        for (NetworkInterface netint : this.getNetworkInterfaces()) {
            NetworkIF netIF = new NetworkIF();
            netIF.setNetworkInterface(netint);
            MacNetworks.updateNetworkStats(netIF, ifDataMap);
            result.add(netIF);
        }
        return result.toArray(new NetworkIF[0]);
    }

    private static Map<Integer, IFdata> queryIFdata(int index) {
        SystemB.IFmsgHdr ifm;
        HashMap<Integer, IFdata> data = new HashMap<Integer, IFdata>();
        int[] mib = new int[]{4, 17, 0, 0, 6, 0};
        IntByReference len = new IntByReference();
        if (0 != SystemB.INSTANCE.sysctl(mib, 6, null, len, null, 0)) {
            LOG.error("Didn't get buffer length for IFLIST2");
            return data;
        }
        Memory buf = new Memory(len.getValue());
        if (0 != SystemB.INSTANCE.sysctl(mib, 6, buf, len, null, 0)) {
            LOG.error("Didn't get buffer for IFLIST2");
            return data;
        }
        int lim = (int)(buf.size() - (long)new SystemB.IFmsgHdr().size());
        for (int offset = 0; offset < lim; offset += ifm.ifm_msglen) {
            Pointer p = buf.share(offset);
            ifm = new SystemB.IFmsgHdr(p);
            ifm.read();
            if (ifm.ifm_type != 18) continue;
            SystemB.IFmsgHdr2 if2m = new SystemB.IFmsgHdr2(p);
            if2m.read();
            if (index >= 0 && index != if2m.ifm_index) continue;
            data.put(Integer.valueOf(if2m.ifm_index), new IFdata(if2m.ifm_data.ifi_opackets, if2m.ifm_data.ifi_ipackets, if2m.ifm_data.ifi_obytes, if2m.ifm_data.ifi_ibytes, if2m.ifm_data.ifi_oerrors, if2m.ifm_data.ifi_ierrors, if2m.ifm_data.ifi_collisions, if2m.ifm_data.ifi_iqdrops, if2m.ifm_data.ifi_baudrate, System.currentTimeMillis()));
        }
        return data;
    }

    public static boolean updateNetworkStats(NetworkIF netIF) {
        int index = netIF.queryNetworkInterface().getIndex();
        return MacNetworks.updateNetworkStats(netIF, MacNetworks.queryIFdata(index));
    }

    private static boolean updateNetworkStats(NetworkIF netIF, Map<Integer, IFdata> data) {
        int index = netIF.queryNetworkInterface().getIndex();
        if (data.containsKey(index)) {
            IFdata ifData = data.get(index);
            netIF.setBytesSent(ifData.oBytes);
            netIF.setBytesRecv(ifData.iBytes);
            netIF.setPacketsSent(ifData.oPackets);
            netIF.setPacketsRecv(ifData.iPackets);
            netIF.setOutErrors(ifData.oErrors);
            netIF.setInErrors(ifData.iErrors);
            netIF.setCollisions(ifData.collisions);
            netIF.setInDrops(ifData.iDrops);
            netIF.setSpeed(ifData.speed);
            netIF.setTimeStamp(ifData.timeStamp);
            return true;
        }
        return false;
    }

    private static class IFdata {
        private long oPackets;
        private long iPackets;
        private long oBytes;
        private long iBytes;
        private long oErrors;
        private long iErrors;
        private long collisions;
        private long iDrops;
        private long speed;
        private long timeStamp;

        IFdata(long oPackets, long iPackets, long oBytes, long iBytes, long oErrors, long iErrors, long collisions, long iDrops, long speed, long timeStamp) {
            this.oPackets = oPackets;
            this.iPackets = iPackets;
            this.oBytes = oBytes;
            this.iBytes = iBytes;
            this.oErrors = oErrors;
            this.iErrors = iErrors;
            this.collisions = collisions;
            this.iDrops = iDrops;
            this.speed = speed;
            this.timeStamp = timeStamp;
        }
    }
}

