/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.linux;

import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.common.AbstractVirtualMemory;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.FileUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.Memoizer;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ParseUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.platform.linux.ProcUtil;
import java.util.List;
import java.util.function.Supplier;

public class LinuxVirtualMemory
extends AbstractVirtualMemory {
    private final Supplier<MemInfo> memInfo = Memoizer.memoize(this::queryMemInfo, Memoizer.defaultExpiration());
    private final Supplier<VmStat> vmStat = Memoizer.memoize(this::queryVmStat, Memoizer.defaultExpiration());

    @Override
    public long getSwapUsed() {
        return this.memInfo.get().used;
    }

    @Override
    public long getSwapTotal() {
        return this.memInfo.get().total;
    }

    @Override
    public long getSwapPagesIn() {
        return this.vmStat.get().pagesIn;
    }

    @Override
    public long getSwapPagesOut() {
        return this.vmStat.get().pagesOut;
    }

    private MemInfo queryMemInfo() {
        long swapFree = 0L;
        long swapTotal = 0L;
        List<String> procMemInfo = FileUtil.readFile(ProcUtil.getProcPath() + "/meminfo");
        for (String checkLine : procMemInfo) {
            String[] memorySplit = ParseUtil.whitespaces.split(checkLine);
            if (memorySplit.length <= 1) continue;
            switch (memorySplit[0]) {
                case "SwapTotal:": {
                    swapTotal = this.parseMeminfo(memorySplit);
                    break;
                }
                case "SwapFree:": {
                    swapFree = this.parseMeminfo(memorySplit);
                    break;
                }
            }
        }
        return new MemInfo(swapTotal, swapTotal - swapFree);
    }

    private VmStat queryVmStat() {
        long swapPagesIn = 0L;
        long swapPagesOut = 0L;
        List<String> procVmStat = FileUtil.readFile(ProcUtil.getProcPath() + "/vmstat");
        for (String checkLine : procVmStat) {
            String[] memorySplit = ParseUtil.whitespaces.split(checkLine);
            if (memorySplit.length <= 1) continue;
            switch (memorySplit[0]) {
                case "pgpgin": {
                    swapPagesIn = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
                    break;
                }
                case "pgpgout": {
                    swapPagesOut = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
                    break;
                }
            }
        }
        return new VmStat(swapPagesIn, swapPagesOut);
    }

    private long parseMeminfo(String[] memorySplit) {
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
        if (memorySplit.length > 2 && "kB".equals(memorySplit[2])) {
            memory *= 1024L;
        }
        return memory;
    }

    private static final class MemInfo {
        private final long total;
        private final long used;

        private MemInfo(long total, long used) {
            this.total = total;
            this.used = used;
        }
    }

    private static final class VmStat {
        private final long pagesIn;
        private final long pagesOut;

        private VmStat(long pagesIn, long pagesOut) {
            this.pagesIn = pagesIn;
            this.pagesOut = pagesOut;
        }
    }
}

