/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.linux;

import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.NetworkIF;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.common.AbstractNetworks;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.FileUtil;
import java.io.File;

public class LinuxNetworks
extends AbstractNetworks {
    public static boolean updateNetworkStats(NetworkIF netIF) {
        try {
            File ifDir = new File(String.format("/sys/class/net/%s/statistics", netIF.getName()));
            if (!ifDir.isDirectory()) {
                return false;
            }
        }
        catch (SecurityException e) {
            return false;
        }
        String txBytesPath = String.format("/sys/class/net/%s/statistics/tx_bytes", netIF.getName());
        String rxBytesPath = String.format("/sys/class/net/%s/statistics/rx_bytes", netIF.getName());
        String txPacketsPath = String.format("/sys/class/net/%s/statistics/tx_packets", netIF.getName());
        String rxPacketsPath = String.format("/sys/class/net/%s/statistics/rx_packets", netIF.getName());
        String txErrorsPath = String.format("/sys/class/net/%s/statistics/tx_errors", netIF.getName());
        String rxErrorsPath = String.format("/sys/class/net/%s/statistics/rx_errors", netIF.getName());
        String collisionsPath = String.format("/sys/class/net/%s/statistics/collisions", netIF.getName());
        String rxDropsPath = String.format("/sys/class/net/%s/statistics/rx_dropped", netIF.getName());
        String speed = String.format("/sys/class/net/%s/speed", netIF.getName());
        netIF.setTimeStamp(System.currentTimeMillis());
        netIF.setBytesSent(FileUtil.getUnsignedLongFromFile(txBytesPath));
        netIF.setBytesRecv(FileUtil.getUnsignedLongFromFile(rxBytesPath));
        netIF.setPacketsSent(FileUtil.getUnsignedLongFromFile(txPacketsPath));
        netIF.setPacketsRecv(FileUtil.getUnsignedLongFromFile(rxPacketsPath));
        netIF.setOutErrors(FileUtil.getUnsignedLongFromFile(txErrorsPath));
        netIF.setInErrors(FileUtil.getUnsignedLongFromFile(rxErrorsPath));
        netIF.setCollisions(FileUtil.getUnsignedLongFromFile(collisionsPath));
        netIF.setInDrops(FileUtil.getUnsignedLongFromFile(rxDropsPath));
        long netSpeed = FileUtil.getUnsignedLongFromFile(speed) * 1024L * 1024L;
        netIF.setSpeed(netSpeed < 0L ? 0L : netSpeed);
        return true;
    }
}

