/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.linux;

import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.VirtualMemory;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.common.AbstractGlobalMemory;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.linux.LinuxVirtualMemory;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ExecutingCommand;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.FileUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.Memoizer;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.ParseUtil;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.platform.linux.ProcUtil;
import java.util.List;
import java.util.function.Supplier;

public class LinuxGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<MemInfo> memInfo = Memoizer.memoize(this::readMemInfo, Memoizer.defaultExpiration());
    private final Supplier<Long> pageSize = Memoizer.memoize(this::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    @Override
    public long getAvailable() {
        return this.memInfo.get().available;
    }

    @Override
    public long getTotal() {
        return this.memInfo.get().total;
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private long queryPageSize() {
        return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("getconf PAGE_SIZE"), 4096L);
    }

    private MemInfo readMemInfo() {
        long memFree = 0L;
        long activeFile = 0L;
        long inactiveFile = 0L;
        long sReclaimable = 0L;
        long memTotal = 0L;
        List<String> procMemInfo = FileUtil.readFile(ProcUtil.getProcPath() + "/meminfo");
        for (String checkLine : procMemInfo) {
            String[] memorySplit = ParseUtil.whitespaces.split(checkLine);
            if (memorySplit.length <= 1) continue;
            switch (memorySplit[0]) {
                case "MemTotal:": {
                    memTotal = this.parseMeminfo(memorySplit);
                    break;
                }
                case "MemAvailable:": {
                    long memAvailable = this.parseMeminfo(memorySplit);
                    return new MemInfo(memTotal, memAvailable);
                }
                case "MemFree:": {
                    memFree = this.parseMeminfo(memorySplit);
                    break;
                }
                case "Active(file):": {
                    activeFile = this.parseMeminfo(memorySplit);
                    break;
                }
                case "Inactive(file):": {
                    inactiveFile = this.parseMeminfo(memorySplit);
                    break;
                }
                case "SReclaimable:": {
                    sReclaimable = this.parseMeminfo(memorySplit);
                    break;
                }
            }
        }
        return new MemInfo(memTotal, memFree + activeFile + inactiveFile + sReclaimable);
    }

    private long parseMeminfo(String[] memorySplit) {
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
        if (memorySplit.length > 2 && "kB".equals(memorySplit[2])) {
            memory *= 1024L;
        }
        return memory;
    }

    private VirtualMemory createVirtualMemory() {
        return new LinuxVirtualMemory();
    }

    private static final class MemInfo {
        private final long total;
        private final long available;

        private MemInfo(long total, long available) {
            this.total = total;
            this.available = available;
        }
    }
}

