/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi.hardware.common;

import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.NetworkIF;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.Networks;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetworks
implements Networks {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetworks.class);

    @Override
    public NetworkIF[] getNetworks() {
        ArrayList<NetworkIF> result = new ArrayList<NetworkIF>();
        for (NetworkInterface netint : this.getNetworkInterfaces()) {
            NetworkIF netIF = new NetworkIF();
            netIF.setNetworkInterface(netint);
            netIF.updateAttributes();
            result.add(netIF);
        }
        return result.toArray(new NetworkIF[0]);
    }

    protected NetworkInterface[] getNetworkInterfaces() {
        ArrayList<NetworkInterface> result = new ArrayList<NetworkInterface>();
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            LOG.error("Socket exception when retrieving interfaces: {}", ex);
        }
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface netint = interfaces.nextElement();
                try {
                    if (netint.isLoopback() || netint.getHardwareAddress() == null) continue;
                    result.add(netint);
                }
                catch (SocketException ex) {
                    LOG.error("Socket exception when retrieving interface \"{}\": {}", (Object)netint.getName(), (Object)ex);
                }
            }
        }
        return result.toArray(new NetworkInterface[0]);
    }
}

