/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.oshi;

import com.gamedash.daemon.wrapper.dependencies.com.sun.jna.Platform;
import com.gamedash.daemon.wrapper.dependencies.oshi.PlatformEnum;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.HardwareAbstractionLayer;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.linux.LinuxHardwareAbstractionLayer;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.mac.MacHardwareAbstractionLayer;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.unix.freebsd.FreeBsdHardwareAbstractionLayer;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.unix.solaris.SolarisHardwareAbstractionLayer;
import com.gamedash.daemon.wrapper.dependencies.oshi.hardware.platform.windows.WindowsHardwareAbstractionLayer;
import com.gamedash.daemon.wrapper.dependencies.oshi.software.os.OperatingSystem;
import com.gamedash.daemon.wrapper.dependencies.oshi.software.os.linux.LinuxOperatingSystem;
import com.gamedash.daemon.wrapper.dependencies.oshi.software.os.mac.MacOperatingSystem;
import com.gamedash.daemon.wrapper.dependencies.oshi.software.os.unix.freebsd.FreeBsdOperatingSystem;
import com.gamedash.daemon.wrapper.dependencies.oshi.software.os.unix.solaris.SolarisOperatingSystem;
import com.gamedash.daemon.wrapper.dependencies.oshi.software.os.windows.WindowsOperatingSystem;
import com.gamedash.daemon.wrapper.dependencies.oshi.util.Memoizer;
import java.util.function.Supplier;

public class SystemInfo {
    private static final PlatformEnum currentPlatformEnum = Platform.isWindows() ? PlatformEnum.WINDOWS : (Platform.isLinux() ? PlatformEnum.LINUX : (Platform.isMac() ? PlatformEnum.MACOSX : (Platform.isSolaris() ? PlatformEnum.SOLARIS : (Platform.isFreeBSD() ? PlatformEnum.FREEBSD : PlatformEnum.UNKNOWN))));
    private final Supplier<OperatingSystem> os = Memoizer.memoize(this::createOperatingSystem);
    private final Supplier<HardwareAbstractionLayer> hardware = Memoizer.memoize(this::createHardware);

    public static PlatformEnum getCurrentPlatformEnum() {
        return currentPlatformEnum;
    }

    public OperatingSystem getOperatingSystem() {
        return this.os.get();
    }

    private OperatingSystem createOperatingSystem() {
        switch (currentPlatformEnum) {
            case WINDOWS: {
                return new WindowsOperatingSystem();
            }
            case LINUX: {
                return new LinuxOperatingSystem();
            }
            case MACOSX: {
                return new MacOperatingSystem();
            }
            case SOLARIS: {
                return new SolarisOperatingSystem();
            }
            case FREEBSD: {
                return new FreeBsdOperatingSystem();
            }
        }
        throw new UnsupportedOperationException("Operating system not supported: " + Platform.getOSType());
    }

    public HardwareAbstractionLayer getHardware() {
        return this.hardware.get();
    }

    private HardwareAbstractionLayer createHardware() {
        switch (currentPlatformEnum) {
            case WINDOWS: {
                return new WindowsHardwareAbstractionLayer();
            }
            case LINUX: {
                return new LinuxHardwareAbstractionLayer();
            }
            case MACOSX: {
                return new MacHardwareAbstractionLayer();
            }
            case SOLARIS: {
                return new SolarisHardwareAbstractionLayer();
            }
            case FREEBSD: {
                return new FreeBsdHardwareAbstractionLayer();
            }
        }
        throw new UnsupportedOperationException("Operating system not supported: " + Platform.getOSType());
    }
}

