/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.servlet;

import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.api.WebSocketBehavior;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class WebSocketServlet
extends HttpServlet {
    private WebSocketServletFactory factory;

    public abstract void configure(WebSocketServletFactory var1);

    @Override
    public void destroy() {
        try {
            this.factory.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void init() throws ServletException {
        try {
            WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
            String max = this.getInitParameter("maxIdleTime");
            if (max != null) {
                policy.setIdleTimeout(Long.parseLong(max));
            }
            if ((max = this.getInitParameter("maxTextMessageSize")) != null) {
                policy.setMaxTextMessageSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("maxBinaryMessageSize")) != null) {
                policy.setMaxBinaryMessageSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("inputBufferSize")) != null) {
                policy.setInputBufferSize(Integer.parseInt(max));
            }
            ServletContext ctx = this.getServletContext();
            this.factory = WebSocketServletFactory.Loader.load(ctx, policy);
            this.configure(this.factory);
            this.factory.start();
            ctx.setAttribute(WebSocketServletFactory.class.getName(), this.factory);
        }
        catch (Exception x) {
            throw new ServletException(x);
        }
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.factory.isUpgradeRequest(request, response)) {
            if (this.factory.acceptWebSocket(request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.service(request, response);
    }
}

