/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.client.io;

import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.io.ByteBufferPool;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.io.EndPoint;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.util.thread.Scheduler;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.api.BatchMode;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.api.WriteCallback;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.client.masks.Masker;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.client.masks.RandomMasker;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.common.WebSocketFrame;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;

public class WebSocketClientConnection
extends AbstractWebSocketConnection {
    private final Masker masker = new RandomMasker();

    public WebSocketClientConnection(EndPoint endp, Executor executor, Scheduler scheduler, WebSocketPolicy websocketPolicy, ByteBufferPool bufferPool) {
        super(endp, executor, scheduler, websocketPolicy, bufferPool);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (frame instanceof WebSocketFrame) {
            this.masker.setMask((WebSocketFrame)frame);
        }
        super.outgoingFrame(frame, callback, batchMode);
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

