/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.server;

import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.http.MultiPartFormInputStream;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.server.Request;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.server.handler.ContextHandler;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.util.MultiPartInputStreamParser;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.Part;

public interface MultiParts
extends Closeable {
    public Collection<Part> getParts();

    public Part getPart(String var1);

    public boolean isEmpty();

    public ContextHandler.Context getContext();

    public static class MultiPartsUtilParser
    implements MultiParts {
        private final MultiPartInputStreamParser _utilParser;
        private final ContextHandler.Context _context;

        public MultiPartsUtilParser(InputStream in, String contentType, MultipartConfigElement config, File contextTmpDir, Request request) throws IOException {
            this._utilParser = new MultiPartInputStreamParser(in, contentType, config, contextTmpDir);
            this._context = request.getContext();
            this._utilParser.getParts();
            EnumSet<MultiPartInputStreamParser.NonCompliance> nonComplianceWarnings = this._utilParser.getNonComplianceWarnings();
            if (!nonComplianceWarnings.isEmpty()) {
                ArrayList<String> violations = (ArrayList<String>)request.getAttribute("com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.http.compliance.violations");
                if (violations == null) {
                    violations = new ArrayList<String>();
                    request.setAttribute("com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.http.compliance.violations", violations);
                }
                for (MultiPartInputStreamParser.NonCompliance nc : nonComplianceWarnings) {
                    violations.add(nc.name() + ": " + nc.getURL());
                }
                System.out.println(violations);
            }
        }

        @Override
        public Collection<Part> getParts() {
            try {
                return this._utilParser.getParts();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Part getPart(String name) {
            try {
                return this._utilParser.getPart(name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            this._utilParser.deleteParts();
        }

        @Override
        public boolean isEmpty() {
            return this._utilParser.getParsedParts().isEmpty();
        }

        @Override
        public ContextHandler.Context getContext() {
            return this._context;
        }
    }

    public static class MultiPartsHttpParser
    implements MultiParts {
        private final MultiPartFormInputStream _httpParser;
        private final ContextHandler.Context _context;

        public MultiPartsHttpParser(InputStream in, String contentType, MultipartConfigElement config, File contextTmpDir, Request request) throws IOException {
            this._httpParser = new MultiPartFormInputStream(in, contentType, config, contextTmpDir);
            this._context = request.getContext();
            this._httpParser.getParts();
        }

        @Override
        public Collection<Part> getParts() {
            try {
                return this._httpParser.getParts();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Part getPart(String name) {
            try {
                return this._httpParser.getPart(name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            this._httpParser.deleteParts();
        }

        @Override
        public boolean isEmpty() {
            return this._httpParser.isEmpty();
        }

        @Override
        public ContextHandler.Context getContext() {
            return this._context;
        }
    }
}

