/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.security;

import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.security.Authenticator;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.security.IdentityService;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.security.LoginService;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.security.authentication.BasicAuthenticator;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.security.authentication.ClientCertAuthenticator;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.security.authentication.DigestAuthenticator;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.security.authentication.FormAuthenticator;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.security.authentication.SpnegoAuthenticator;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.server.Server;
import javax.servlet.ServletContext;

public class DefaultAuthenticatorFactory
implements Authenticator.Factory {
    LoginService _loginService;

    @Override
    public Authenticator getAuthenticator(Server server, ServletContext context, Authenticator.AuthConfiguration configuration, IdentityService identityService, LoginService loginService) {
        String auth = configuration.getAuthMethod();
        LoginAuthenticator authenticator = null;
        if (auth == null || "BASIC".equalsIgnoreCase(auth)) {
            authenticator = new BasicAuthenticator();
        } else if ("DIGEST".equalsIgnoreCase(auth)) {
            authenticator = new DigestAuthenticator();
        } else if ("FORM".equalsIgnoreCase(auth)) {
            authenticator = new FormAuthenticator();
        } else if ("SPNEGO".equalsIgnoreCase(auth)) {
            authenticator = new SpnegoAuthenticator();
        } else if ("NEGOTIATE".equalsIgnoreCase(auth)) {
            authenticator = new SpnegoAuthenticator("NEGOTIATE");
        }
        if ("CLIENT_CERT".equalsIgnoreCase(auth) || "CLIENT-CERT".equalsIgnoreCase(auth)) {
            authenticator = new ClientCertAuthenticator();
        }
        return authenticator;
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        this._loginService = loginService;
    }
}

