/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.client;

import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.client.AuthenticationProtocolHandler;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.client.HttpClient;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.client.api.Request;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.client.api.Response;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.http.HttpHeader;
import java.net.URI;

public class WWWAuthenticationProtocolHandler
extends AuthenticationProtocolHandler {
    public static final String NAME = "www-authenticate";
    private static final String ATTRIBUTE = WWWAuthenticationProtocolHandler.class.getName() + ".attribute";

    public WWWAuthenticationProtocolHandler(HttpClient client) {
        this(client, 16384);
    }

    public WWWAuthenticationProtocolHandler(HttpClient client, int maxContentLength) {
        super(client, maxContentLength);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        return response.getStatus() == 401;
    }

    @Override
    protected HttpHeader getAuthenticateHeader() {
        return HttpHeader.WWW_AUTHENTICATE;
    }

    @Override
    protected HttpHeader getAuthorizationHeader() {
        return HttpHeader.AUTHORIZATION;
    }

    @Override
    protected URI getAuthenticationURI(Request request) {
        return request.getURI();
    }

    @Override
    protected String getAuthenticationAttribute() {
        return ATTRIBUTE;
    }
}

