/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.client;

import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.client.Synchronizable;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.client.api.ContentProvider;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.util.BufferUtil;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.util.Callback;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.util.log.Log;
import com.gamedash.daemon.wrapper.dependencies.org.eclipse.jetty.util.log.Logger;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;

public class HttpContent
implements Callback,
Closeable {
    private static final Logger LOG = Log.getLogger(HttpContent.class);
    private static final ByteBuffer AFTER = ByteBuffer.allocate(0);
    private static final ByteBuffer CLOSE = ByteBuffer.allocate(0);
    private final ContentProvider provider;
    private final Iterator<ByteBuffer> iterator;
    private ByteBuffer buffer;
    private ByteBuffer content;
    private boolean last;

    public HttpContent(ContentProvider provider) {
        this.provider = provider;
        this.iterator = provider == null ? Collections.emptyIterator() : provider.iterator();
    }

    private static boolean isTheCloseBuffer(ByteBuffer buffer) {
        boolean isTheCloseBuffer = buffer == CLOSE;
        return isTheCloseBuffer;
    }

    public boolean hasContent() {
        return this.provider != null;
    }

    public boolean isLast() {
        return this.last;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean advance() {
        if (this.iterator instanceof Synchronizable) {
            Object object = ((Synchronizable)((Object)this.iterator)).getLock();
            synchronized (object) {
                return this.advance(this.iterator);
            }
        }
        return this.advance(this.iterator);
    }

    private boolean advance(Iterator<ByteBuffer> iterator) {
        boolean hasNext = iterator.hasNext();
        ByteBuffer bytes = hasNext ? iterator.next() : null;
        boolean hasMore = hasNext && iterator.hasNext();
        boolean wasLast = this.last;
        boolean bl = this.last = !hasMore;
        if (hasNext) {
            this.buffer = bytes;
            ByteBuffer byteBuffer = this.content = bytes == null ? null : bytes.slice();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Advanced content to {} chunk {}", hasMore ? "next" : "last", String.valueOf(bytes));
            }
            return bytes != null;
        }
        if (wasLast) {
            this.buffer = this.content = AFTER;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Advanced content past last chunk", new Object[0]);
            }
        } else {
            this.buffer = this.content = CLOSE;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Advanced content to last chunk", new Object[0]);
            }
        }
        return false;
    }

    public boolean isConsumed() {
        return this.buffer == AFTER;
    }

    @Override
    public void succeeded() {
        if (this.isConsumed()) {
            return;
        }
        if (HttpContent.isTheCloseBuffer(this.buffer)) {
            return;
        }
        if (this.iterator instanceof Callback) {
            ((Callback)((Object)this.iterator)).succeeded();
        }
    }

    @Override
    public void failed(Throwable x) {
        if (this.isConsumed()) {
            return;
        }
        if (HttpContent.isTheCloseBuffer(this.buffer)) {
            return;
        }
        if (this.iterator instanceof Callback) {
            ((Callback)((Object)this.iterator)).failed(x);
        }
    }

    @Override
    public void close() {
        try {
            if (this.iterator instanceof Closeable) {
                ((Closeable)((Object)this.iterator)).close();
            }
        }
        catch (Throwable x) {
            LOG.ignore(x);
        }
    }

    public String toString() {
        return String.format("%s@%x - has=%b,last=%b,consumed=%b,buffer=%s", this.getClass().getSimpleName(), this.hashCode(), this.hasContent(), this.isLast(), this.isConsumed(), BufferUtil.toDetailString(this.getContent()));
    }
}

