/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.org.apache.http.impl.conn;

import com.gamedash.daemon.wrapper.dependencies.org.apache.http.HttpResponse;
import com.gamedash.daemon.wrapper.dependencies.org.apache.http.HttpResponseFactory;
import com.gamedash.daemon.wrapper.dependencies.org.apache.http.annotation.Contract;
import com.gamedash.daemon.wrapper.dependencies.org.apache.http.annotation.ThreadingBehavior;
import com.gamedash.daemon.wrapper.dependencies.org.apache.http.config.MessageConstraints;
import com.gamedash.daemon.wrapper.dependencies.org.apache.http.impl.DefaultHttpResponseFactory;
import com.gamedash.daemon.wrapper.dependencies.org.apache.http.impl.conn.DefaultHttpResponseParser;
import com.gamedash.daemon.wrapper.dependencies.org.apache.http.io.HttpMessageParser;
import com.gamedash.daemon.wrapper.dependencies.org.apache.http.io.HttpMessageParserFactory;
import com.gamedash.daemon.wrapper.dependencies.org.apache.http.io.SessionInputBuffer;
import com.gamedash.daemon.wrapper.dependencies.org.apache.http.message.BasicLineParser;
import com.gamedash.daemon.wrapper.dependencies.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

