/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.me.tongfei.progressbar;

import java.time.Instant;

class ProgressState {
    String task;
    boolean indefinite = false;
    long current = 0L;
    long max = 0L;
    Instant startTime = null;
    String extraMessage = "";

    ProgressState(String task, long initialMax) {
        this.task = task;
        this.max = initialMax;
        if (initialMax < 0L) {
            this.indefinite = true;
        }
    }

    synchronized void setAsDefinite() {
        this.indefinite = false;
    }

    synchronized void setAsIndefinite() {
        this.indefinite = true;
    }

    synchronized void maxHint(long n) {
        this.max = n;
    }

    synchronized void stepBy(long n) {
        this.current += n;
        if (this.current > this.max) {
            this.max = this.current;
        }
    }

    synchronized void stepTo(long n) {
        this.current = n;
        if (this.current > this.max) {
            this.max = this.current;
        }
    }

    synchronized void setExtraMessage(String msg) {
        this.extraMessage = msg;
    }

    String getTask() {
        return this.task;
    }

    synchronized String getExtraMessage() {
        return this.extraMessage;
    }

    synchronized long getCurrent() {
        return this.current;
    }

    synchronized long getMax() {
        return this.max;
    }

    synchronized double prog() {
        if (this.max <= 0L) {
            return 0.0;
        }
        return (double)this.current / (double)this.max;
    }
}

