/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.version;

import com.gamedash.daemon.wrapper.dependencies.com.google.gson.JsonArray;
import com.gamedash.daemon.wrapper.dependencies.com.google.gson.JsonElement;
import com.gamedash.daemon.wrapper.dependencies.com.google.gson.JsonObject;
import com.gamedash.daemon.wrapper.dependencies.com.schokkerit.restapi.client.response.IQueryResponse;
import com.gamedash.daemon.wrapper.dependencies.common.dataTypes.Uri;
import com.gamedash.daemon.wrapper.dependencies.common.fileSystem.FileSystem;
import com.gamedash.daemon.wrapper.dependencies.common.version.Version;
import com.gamedash.daemon.wrapper.dependencies.common.version.api.client.ApiClient;
import com.gamedash.daemon.wrapper.dependencies.common.version.api.client.ApiQuery;
import com.gamedash.daemon.wrapper.dependencies.common.version.file.VersionFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Versions {
    private static List<Version> allVersions;

    public static synchronized List<Version> getAll() throws Exception {
        if (allVersions == null) {
            ApiQuery apiQuery = ApiClient.createQuery("version/all");
            IQueryResponse queryResponse = apiQuery.get();
            JsonArray jsonVersionElements = queryResponse.getJsonObject().get("response").getAsJsonArray();
            ArrayList<Version> versions = new ArrayList<Version>();
            for (JsonElement jsonVersionElement : jsonVersionElements) {
                JsonObject jsonVersionObject = jsonVersionElement.getAsJsonObject();
                Version version = new Version(jsonVersionObject.get("id").getAsString());
                if (jsonVersionObject.get("isLatest").getAsBoolean()) {
                    version.setIsLatest(true);
                }
                jsonVersionObject.get("compatible").getAsJsonArray().forEach(compatibleVersionJsonElement -> version.addCompatible(new Version(compatibleVersionJsonElement.getAsString())));
                jsonVersionObject.get("files").getAsJsonArray().forEach(fileJsonElement -> {
                    JsonObject fileJsonObject = fileJsonElement.getAsJsonObject();
                    version.getFiles().add(new VersionFile(version, fileJsonObject.get("name").getAsString(), Uri.fromString(fileJsonObject.get("uri").getAsString()), fileJsonObject.get("SHA1Checksum").getAsString()));
                });
                versions.add(version);
            }
            allVersions = versions;
        }
        return allVersions;
    }

    public static Version get(String id) throws Exception {
        for (Version version : Versions.getAll()) {
            if (!version.isEqualTo(id)) continue;
            return version;
        }
        return null;
    }

    public static Version getLatest() throws Exception {
        for (Version version : Versions.getAll()) {
            if (!version.isLatest().booleanValue()) continue;
            return version;
        }
        return null;
    }

    public static File getDirectory() {
        return new File(FileSystem.getRootDirectory().getPath() + "/versions");
    }

    public static void clearCache() {
        allVersions = null;
    }
}

