/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.utilities;

import com.gamedash.daemon.wrapper.dependencies.common.time.Time;

public class ExpiringValue<T> {
    private Time time;
    private Integer threshold;
    private T value;

    public ExpiringValue() {
    }

    public ExpiringValue(T value) {
        if (value != null) {
            this.setValue(value);
        }
    }

    public T getValue() {
        if (this.hasExpired()) {
            return null;
        }
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean hasExpired() {
        Time time = this.getTime();
        return time != null && time.getTimestamp() - Time.now().getTimestamp() > (long)this.getThreshold().intValue();
    }

    public Time getTime() {
        return this.time;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    public void resetTime() {
        if (this.getThreshold() != null) {
            this.setTime(Time.fromTimestamp(Time.now().getTimestamp() + (long)this.getThreshold().intValue()));
        }
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }
}

