/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.singleton;

import java.util.ArrayList;
import java.util.List;

public abstract class SingletonList<T> {
    private List<T> list;

    public List<T> getAll() {
        return this.list;
    }

    public boolean isEmpty() {
        return this.list != null;
    }

    public T find(IFindCallback<T> callback) {
        if (this.getAll() != null) {
            for (T item : this.getAll()) {
                if (!callback.compare(item)) continue;
                return item;
            }
        }
        return null;
    }

    public void add(T item) {
        this.acquireList().add(item);
    }

    public void addAll(List<T> items) {
        this.acquireList().addAll(items);
    }

    public void remove(T item) {
        if (this.getAll() != null) {
            this.getAll().forEach(_item -> {
                if (this.compare(item, _item)) {
                    this.list.remove(_item);
                }
            });
        }
    }

    public boolean notEmpty() {
        return this.list != null;
    }

    public void clear() {
        this.list = null;
    }

    public T handle(IFindCallback<T> findCallback, IHandleFetchCallback<T> fetchCallback) {
        T value = this.find(findCallback);
        if (value == null) {
            value = fetchCallback.method();
            this.add(value);
        }
        return value;
    }

    public abstract boolean compare(T var1, T var2);

    private List<T> acquireList() {
        if (this.list == null) {
            this.list = new ArrayList<T>();
        }
        return this.list;
    }

    @FunctionalInterface
    public static interface IHandleFetchCallback<T> {
        public T method();
    }

    @FunctionalInterface
    public static interface IFindCallback<T> {
        public boolean compare(T var1);
    }
}

